/*
 * This file is part of JBizMo, a set of tools, libraries and plug-ins
 * for modeling and creating Java-based enterprise applications.
 * For more information visit:
 *
 * http://sourceforge.net/projects/jbizmo/
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package net.sourceforge.jbizmo.commons.search.dto;

import java.io.Serializable;
import java.util.Vector;

/**
 * <p>
 * Data transfer object for query results
 * </p>
 * <p>
 * Copyright 2010 (C) by Martin Ganserer
 * </p>
 * @author Martin Ganserer
 * @version 1.0.0
 */
public class SearchResultDTO implements Serializable
{
	private static final long serialVersionUID = 1L;
	private long countResult;
	private Vector<String[]> resultSet;
	private SearchDTO searchDTO;

	/**
	 * @return the search DTO
	 */
	public SearchDTO getSearchDTO()
	{
		return searchDTO;
	}

	/**
	 * @param searchDTO
	 */
	public void setSearchDTO(SearchDTO searchDTO)
	{
		this.searchDTO = searchDTO;
	}

	/**
	 * @return the number of all results a query would generate
	 */
	public long getCountResult()
	{
		return countResult;
	}

	/**
	 * Set count result
	 * @param countResult
	 */
	public void setCountResult(long countResult)
	{
		this.countResult = countResult;
	}

	/**
	 * @return the result set
	 */
	public Vector<String[]> getResultSet()
	{
		return resultSet;
	}

	/**
	 * Set result set
	 * @param resultSet
	 */
	public void setResultSet(Vector<String[]> resultSet)
	{
		this.resultSet = resultSet;
	}

}
