/*
 * This file is part of JBizMo, a set of tools, libraries and plug-ins
 * for modeling and creating Java-based enterprise applications.
 * For more information visit:
 *
 * http://sourceforge.net/projects/jbizmo/
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package net.sourceforge.jbizmo.commons.search;

import java.util.Collection;

/**
 * <p>
 * Generic search service
 * </p>
 * <p>
 * Copyright 2010 (C) by Martin Ganserer
 * </p>
 * @author Martin Ganserer
 * @version 1.0.0
 */
public interface SearchService
{
	public static final String OPERATOR_IN = "in";
	public static final String OPERATOR_NOT_IN = "not in";
	public static final String OPERATOR_BETWEEN = "between";
	public static final String OPERATOR_IS_NULL = "is null";
	public static final String OPERATOR_IS_NOT_NULL = "is not null";
	public static final String OPERATOR_LIKE = "like";
	public static final String OPERATOR_NOT_LIKE = "not like";
	public static final String OPERATOR_EQUAL = "=";
	public static final String OPERATOR_GREATER = ">";
	public static final String OPERATOR_SMALLER = "<";
	public static final String OPERATOR_GREATER_OR_EQUAL = ">=";
	public static final String OPERATOR_SMALLER_OR_EQUAL = "<=";
	public static final String TOKEN_DELIMITER_IN = ";;";
	public static final String TOKEN_DELIMITER_BETWEEN = "  ";

	/**
	 * Method that returns a list of values that begins with specified prefix
	 * @param command
	 * @param prefix
	 * @return a collection of values that begin with prefix
	 */
	public Collection<String> getListOfValues(String command, String prefix);
}
