/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.server.security;

import java.lang.invoke.MethodHandles;
import javax.security.enterprise.identitystore.PasswordHash;
import net.sourceforge.jbizmo.commons.crypto.HashGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256PasswordHash
implements PasswordHash {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public String generate(char[] password) {
        try {
            return HashGenerator.encryptSHA256((String)new String(password));
        }
        catch (Exception e) {
            logger.error("Error while encrypting password!", (Throwable)e);
            return "";
        }
    }

    public boolean verify(char[] password, String hashedPassword) {
        try {
            return HashGenerator.encryptSHA256((String)new String(password)).equals(hashedPassword);
        }
        catch (Exception e) {
            logger.error("Error while encrypting password!", (Throwable)e);
            return false;
        }
    }
}

