/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.server.logging;

import javax.ejb.ApplicationException;
import javax.ejb.EJB;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import net.sourceforge.jbizmo.commons.crud.ConcurrentEntityModificationException;
import net.sourceforge.jbizmo.commons.crud.DuplicateCollectionEntryException;
import net.sourceforge.jbizmo.commons.crud.UniqueConstraintViolationException;
import net.sourceforge.jbizmo.commons.exchange.DataExportException;
import net.sourceforge.jbizmo.commons.exchange.DataImportException;
import net.sourceforge.jbizmo.commons.search.exception.GeneralSearchException;
import net.sourceforge.jbizmo.commons.server.logging.Logger;
import net.sourceforge.jbizmo.commons.server.logging.LoggingDTO;
import net.sourceforge.jbizmo.commons.server.logging.LoggingService;
import net.sourceforge.jbizmo.commons.validation.PropertyConstraintViolationException;

public class LoggingInterceptor {
    @EJB
    private LoggingService logService;

    @AroundInvoke
    public Object log(InvocationContext invocationContext) throws Exception {
        long start = System.currentTimeMillis();
        String className = invocationContext.getTarget().getClass().getName();
        try {
            Object obj = invocationContext.proceed();
            if (Logger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LoggingDTO logEntry = new LoggingDTO(className, invocationContext.getMethod().getName(), null, Long.valueOf(end - start), null);
                this.logService.debug(logEntry);
            }
            return obj;
        }
        catch (Exception e) {
            long end = System.currentTimeMillis();
            boolean isApplicationException = false;
            LoggingDTO logEntry = new LoggingDTO(className, invocationContext.getMethod().getName(), null, Long.valueOf(end - start), (Throwable)e);
            if (e.getClass().isAnnotationPresent(ApplicationException.class)) {
                isApplicationException = true;
            }
            if (e.getClass() == ConcurrentEntityModificationException.class) {
                isApplicationException = true;
            }
            if (e.getClass() == UniqueConstraintViolationException.class) {
                isApplicationException = true;
            }
            if (e.getClass() == DuplicateCollectionEntryException.class) {
                isApplicationException = true;
            }
            if (e.getClass() == PropertyConstraintViolationException.class) {
                isApplicationException = true;
            }
            if (e.getClass() == GeneralSearchException.class) {
                isApplicationException = true;
            }
            if (e.getClass() == DataExportException.class) {
                isApplicationException = true;
            }
            if (e.getClass() == DataImportException.class) {
                isApplicationException = true;
            }
            if (isApplicationException) {
                if (Logger.isWarnEnabled()) {
                    this.logService.warn(logEntry);
                }
            } else if (Logger.isErrorEnabled()) {
                this.logService.error(logEntry);
            }
            throw e;
        }
    }
}

