/*
 * This file is part of JBizMo, a set of tools, libraries and plug-ins
 * for modeling and creating Java-based enterprise applications.
 * For more information visit:
 *
 * http://sourceforge.net/projects/jbizmo/
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package net.sourceforge.jbizmo.commons.server.logging;

import static net.sourceforge.jbizmo.commons.server.logging.LoggingService.DEBUG;
import static net.sourceforge.jbizmo.commons.server.logging.LoggingService.DISABLED;
import static net.sourceforge.jbizmo.commons.server.logging.LoggingService.ERROR;
import static net.sourceforge.jbizmo.commons.server.logging.LoggingService.INFO;
import static net.sourceforge.jbizmo.commons.server.logging.LoggingService.NOT_INITIALIZED;
import static net.sourceforge.jbizmo.commons.server.logging.LoggingService.WARN;
import net.sourceforge.jbizmo.commons.property.IllegalPropertyValueException;
import net.sourceforge.jbizmo.commons.property.PropertyService;

/**
 * <p>
 * Utility class that reads logging level from application.properties file
 * </p>
 * <p>
 * Copyright 2010 (C) by Martin Ganserer
 * </p>
 * @author Martin Ganserer
 * @version 1.0.0
 */
public class Logger
{
	private static int loggingLevelValue = NOT_INITIALIZED;

	static
	{
		init();
	}

	/**
	 * This class is a singleton
	 */
	private Logger()
	{
	}

	/**
	 * Initialize log level
	 */
	private static synchronized void init()
	{
		try
		{
			loggingLevelValue = PropertyService.getIntProperty(PropertyService.PROP_LOGGING_LEVEL);
		}
		catch (final IllegalPropertyValueException e)
		{
			// It might be the case that application.properties file does not contain valid property!
			loggingLevelValue = DISABLED;
		}
	}

	/**
	 * @return true if application should log everything
	 */
	public static boolean isDebugEnabled()
	{
		if(loggingLevelValue >= DEBUG)
			return true;

		return false;
	}

	/**
	 * @return true if log level is info
	 */
	public static boolean isInfoEnabled()
	{
		if(loggingLevelValue >= INFO)
			return true;

		return false;
	}

	/**
	 * @return true if log level is warn
	 */
	public static boolean isWarnEnabled()
	{
		if(loggingLevelValue >= WARN)
			return true;

		return false;
	}

	/**
	 * @return true if application should log errors only
	 */
	public static boolean isErrorEnabled()
	{
		if(loggingLevelValue >= ERROR)
			return true;

		return false;
	}

}
