/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.avro.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import net.sourceforge.jbizmo.commons.avro.util.AvroObjectDeserializationException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroObjectDeserializer<T extends SpecificRecordBase> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Schema schema;

    public AvroObjectDeserializer(Schema schema) {
        this.schema = schema;
    }

    public T deserialize(byte[] data) {
        logger.debug("Deserialize byte array with schema '{}'", (Object)this.schema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, null);
        SpecificDatumReader reader = new SpecificDatumReader(this.schema);
        try {
            return (T)((SpecificRecordBase)reader.read(null, (Decoder)decoder));
        }
        catch (IOException e) {
            String errorMsg = "Failed to deserialize Avro object with schema '" + this.schema + "'!";
            logger.error(errorMsg, (Throwable)e);
            throw new AvroObjectDeserializationException(errorMsg, e);
        }
    }
}

