/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.avro.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import net.sourceforge.jbizmo.commons.avro.types.Uuid;

public class UuidConverter {
    private UuidConverter() {
    }

    public static Uuid from(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return new Uuid(byteBuffer.array());
    }

    public static UUID getUUID(Uuid value) {
        byte[] mostSigBits = new byte[8];
        System.arraycopy(value.bytes(), 0, mostSigBits, 0, 8);
        byte[] leastSigBits = new byte[8];
        System.arraycopy(value.bytes(), 8, leastSigBits, 0, 8);
        return new UUID(UuidConverter.bytesToLong(mostSigBits), UuidConverter.bytesToLong(leastSigBits));
    }

    private static long bytesToLong(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.put(bytes);
        byteBuffer.flip();
        return byteBuffer.getLong();
    }
}

