/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.avro.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import net.sourceforge.jbizmo.commons.avro.util.AvroObjectSerializationException;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroObjectSerializer<T extends SpecificRecordBase> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final T object;

    public AvroObjectSerializer(T object) {
        this.object = object;
    }

    public byte[] serialize() {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            logger.debug("Serialize object: {}", this.object);
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
            SpecificDatumWriter datumWriter = new SpecificDatumWriter(this.object.getSchema());
            datumWriter.write(this.object, (Encoder)encoder);
            encoder.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable encoder) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable) {
                    encoder.addSuppressed(throwable);
                }
                throw encoder;
            }
            catch (IOException e) {
                String errorMsg = "Failed to serialize Avro object with schema '" + this.object.getSchema() + "'!";
                logger.error(errorMsg, (Throwable)e);
                throw new AvroObjectSerializationException(errorMsg, e);
            }
        }
        out.close();
        return byArray;
    }
}

