/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jbizmo.commons.avro.util;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import net.sourceforge.jbizmo.commons.avro.types.Uuid;
import net.sourceforge.jbizmo.commons.avro.util.AvroObjectConversionException;
import net.sourceforge.jbizmo.commons.avro.util.UuidConverter;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroObjectConverter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ENUM_METHOD_VALUE_OF = "valueOf";
    private static final String ENUM_LITERAL_METHOD_NAME = "name";

    private AvroObjectConverter() {
    }

    public static <T extends SpecificRecordBase> T toAvro(Object object, Class<T> avroType) {
        logger.debug("Converting object of type {} to {}", (Object)object.getClass().getName(), (Object)avroType.getName());
        try {
            SpecificRecordBase avroRecord = (SpecificRecordBase)avroType.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : object.getClass().getDeclaredFields()) {
                Schema.Field avroField = avroRecord.getSchema().getField(field.getName());
                if (avroField == null) continue;
                Class<?> sourceFieldType = field.getType();
                Object fieldValue = null;
                logger.debug("Processing field '{}' with type {}", (Object)field.getName(), (Object)sourceFieldType.getName());
                field.setAccessible(true);
                if (field.get(object) != null) {
                    if (AvroObjectConverter.omitConversion(sourceFieldType)) {
                        fieldValue = field.get(object);
                    } else if (sourceFieldType == GregorianCalendar.class) {
                        fieldValue = ((GregorianCalendar)field.get(object)).toInstant();
                    } else if (sourceFieldType == Date.class) {
                        fieldValue = ((Date)field.get(object)).toInstant();
                    } else if (sourceFieldType == LocalDateTime.class) {
                        fieldValue = ((LocalDateTime)field.get(object)).atZone(ZoneId.systemDefault()).toInstant();
                    } else if (sourceFieldType == UUID.class) {
                        fieldValue = UuidConverter.from((UUID)field.get(object));
                    } else if (sourceFieldType == Character.TYPE) {
                        fieldValue = String.valueOf(((Character)field.get(object)).charValue());
                    } else if (sourceFieldType.isEnum()) {
                        Method valueOf = Class.forName(avroField.schema().getFullName()).getMethod(ENUM_METHOD_VALUE_OF, String.class);
                        Method name = sourceFieldType.getMethod(ENUM_LITERAL_METHOD_NAME, new Class[0]);
                        fieldValue = valueOf.invoke(null, name.invoke(field.get(object), new Object[0]));
                    } else if (sourceFieldType == Collection.class || sourceFieldType == List.class) {
                        Collection objectList = (Collection)field.get(object);
                        Schema elementType = avroField.schema().getElementType();
                        Class<?> targetType = Class.forName(elementType.getFullName());
                        fieldValue = objectList.stream().map(item -> AvroObjectConverter.toAvro(item, targetType)).toList();
                    } else {
                        String typeName = avroField.schema().getFullName();
                        if (avroField.schema().isUnion()) {
                            typeName = avroField.schema().getTypes().stream().filter(type -> type.getName().equals(sourceFieldType.getSimpleName())).map(Schema::getFullName).findFirst().orElseThrow();
                        }
                        fieldValue = AvroObjectConverter.toAvro(field.get(object), Class.forName(typeName));
                    }
                }
                avroRecord.put(avroField.name(), fieldValue);
            }
            return (T)avroRecord;
        }
        catch (Exception e) {
            String errorMsg = "Error while converting an object of type " + object.getClass().getName() + "!";
            logger.error(errorMsg, (Throwable)e);
            throw new AvroObjectConversionException(errorMsg, e);
        }
    }

    public static <T extends SpecificRecordBase, S> List<T> toAvroList(List<S> objectList, Class<T> avroType) {
        return objectList.stream().map(obj -> AvroObjectConverter.toAvro(obj, avroType)).toList();
    }

    public static <T> T toObject(SpecificRecordBase avroRecord, Class<T> type) {
        logger.debug("Converting Avro record {} to {}", (Object)avroRecord.getClass().getName(), (Object)type.getName());
        try {
            T object = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Schema.Field avroField : avroRecord.getSchema().getFields()) {
                Field targetField = object.getClass().getDeclaredField(avroField.name());
                targetField.setAccessible(true);
                Object fieldValue = null;
                if (avroRecord.get(avroField.name()) != null) {
                    Class<?> sourceFieldType = avroRecord.get(avroField.name()).getClass();
                    Class<?> targetFieldType = targetField.getType();
                    logger.debug("Processing field '{}' with type {}", (Object)avroField.name(), (Object)sourceFieldType.getName());
                    if (sourceFieldType == Instant.class) {
                        Instant instant = (Instant)avroRecord.get(avroField.name());
                        fieldValue = targetFieldType == GregorianCalendar.class ? GregorianCalendar.from(ZonedDateTime.ofInstant(instant, ZoneId.systemDefault())) : (targetFieldType == Date.class ? Date.from(instant) : (targetFieldType == LocalDate.class ? LocalDate.ofInstant(instant, ZoneId.systemDefault()) : (targetFieldType == LocalDateTime.class ? LocalDateTime.ofInstant(instant, ZoneId.systemDefault()) : avroRecord.get(avroField.name()))));
                    } else if (sourceFieldType == String.class && targetFieldType == Character.TYPE) {
                        String string = (String)avroRecord.get(avroField.name());
                        fieldValue = Character.valueOf(string.charAt(0));
                    } else if (sourceFieldType == Uuid.class) {
                        fieldValue = UuidConverter.getUUID((Uuid)((Object)avroRecord.get(avroField.name())));
                    } else if (sourceFieldType.isEnum()) {
                        Method valueOf = targetFieldType.getMethod(ENUM_METHOD_VALUE_OF, String.class);
                        Method name = avroRecord.get(avroField.name()).getClass().getMethod(ENUM_LITERAL_METHOD_NAME, new Class[0]);
                        fieldValue = valueOf.invoke(null, name.invoke(avroRecord.get(avroField.name()), new Object[0]));
                    } else if (avroRecord.get(avroField.name()) instanceof List) {
                        ParameterizedType paramType = (ParameterizedType)targetField.getGenericType();
                        Class<?> targetType = Class.forName(paramType.getActualTypeArguments()[0].getTypeName());
                        List avroList = (List)avroRecord.get(avroField.name());
                        fieldValue = avroList.stream().map(item -> AvroObjectConverter.toObject(item, targetType)).toList();
                    } else {
                        Object object2 = avroRecord.get(avroField.name());
                        if (object2 instanceof SpecificRecordBase) {
                            SpecificRecordBase specificRecordBase = (SpecificRecordBase)object2;
                            fieldValue = AvroObjectConverter.toObject(specificRecordBase, targetFieldType);
                        } else {
                            fieldValue = avroRecord.get(avroField.name());
                        }
                    }
                }
                targetField.set(object, fieldValue);
            }
            return object;
        }
        catch (Exception e) {
            String errorMsg = "Error while converting an Avro object of type " + avroRecord.getClass().getName() + "!";
            logger.error(errorMsg, (Throwable)e);
            throw new AvroObjectConversionException(errorMsg, e);
        }
    }

    public static <T, S extends SpecificRecordBase> List<T> toObjectList(List<S> avroList, Class<T> objectType) {
        return avroList.stream().map(obj -> AvroObjectConverter.toObject(obj, objectType)).toList();
    }

    private static boolean omitConversion(Class<?> type) {
        return type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || type == Boolean.TYPE || type == Boolean.class || type == Long.class || type == Integer.class || type == String.class || type == Double.class || type == Float.class || type == LocalDate.class || type == BigDecimal.class;
    }
}

