/*
 * This file is part of JBizMo, a set of tools, libraries and plug-ins
 * for modeling and creating Java-based enterprise applications.
 * For more information visit:
 *
 * http://sourceforge.net/projects/jbizmo/
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package net.sourceforge.jbizmo.commons.avro.util;

/**
 * <p>
 * Exception that will be thrown if the conversion of an Avro object has failed
 * </p>
 * <p>
 * Copyright 2021 (C) by Martin Ganserer
 * </p>
 * @author Martin Ganserer
 * @version 1.0.0
 */
public class AvroObjectConversionException extends RuntimeException {
	private static final long serialVersionUID = 76698156338803096L;

	/**
	 * Constructor
	 * @param message
	 */
	public AvroObjectConversionException(String message) {
		super(message);
	}

	/**
	 * Constructor
	 * @param message
	 * @param e
	 */
	public AvroObjectConversionException(String message, Exception e) {
		super(message, e);
	}

}
