/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.metrics.api.location;

import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.metrics.model.LocationScope;
import net.sourceforge.cobertura.metrics.model.location.SourceLocation;
import org.apache.commons.lang3.Validate;
import se.jguru.nazgul.core.algorithms.api.collections.predicate.Filter;

public class SourceLocationFilter
implements Filter<SourceLocation> {
    private static final LocationScope[] COMPARISON_ORDER = new LocationScope[]{LocationScope.PACKAGE, LocationScope.CLASS, LocationScope.METHOD, LocationScope.LINE, LocationScope.SEGMENT};
    private LocationScope scope;
    private boolean acceptAllInProject;
    private SortedMap<LocationScope, Pattern> locationPatternMap;

    public SourceLocationFilter() {
        this.setupInternalState(LocationScope.PROJECT);
    }

    public SourceLocationFilter(String packagePattern) {
        this.setupInternalState(LocationScope.PACKAGE);
        this.compilePattern(LocationScope.PACKAGE, packagePattern);
    }

    public SourceLocationFilter(String packagePattern, String classPattern) {
        this.setupInternalState(LocationScope.CLASS);
        this.compilePattern(LocationScope.PACKAGE, packagePattern);
        this.compilePattern(LocationScope.CLASS, classPattern);
    }

    public SourceLocationFilter(String packagePattern, String classPattern, String methodPattern) {
        this.setupInternalState(LocationScope.METHOD);
        this.compilePattern(LocationScope.PACKAGE, packagePattern);
        this.compilePattern(LocationScope.CLASS, classPattern);
        this.compilePattern(LocationScope.METHOD, methodPattern);
    }

    public SourceLocationFilter(String packagePattern, String classPattern, String methodPattern, String lineNumberPattern) {
        this.setupInternalState(LocationScope.LINE);
        this.compilePattern(LocationScope.PACKAGE, packagePattern);
        this.compilePattern(LocationScope.CLASS, classPattern);
        this.compilePattern(LocationScope.METHOD, methodPattern);
        this.compilePattern(LocationScope.LINE, lineNumberPattern);
    }

    public SourceLocationFilter(String packagePattern, String classPattern, String methodPattern, String lineNumberPattern, String branchSegmentPattern) {
        this.setupInternalState(LocationScope.SEGMENT);
        this.compilePattern(LocationScope.PACKAGE, packagePattern);
        this.compilePattern(LocationScope.CLASS, classPattern);
        this.compilePattern(LocationScope.METHOD, methodPattern);
        this.compilePattern(LocationScope.LINE, lineNumberPattern);
        this.compilePattern(LocationScope.SEGMENT, branchSegmentPattern);
    }

    public final LocationScope getScope() {
        return this.scope;
    }

    public boolean accept(SourceLocation candidate) {
        if (this.acceptAllInProject) {
            return true;
        }
        for (LocationScope current : COMPARISON_ORDER) {
            if (current.compareTo((Enum)this.scope) > 0) break;
            String toMatch = "" + candidate.get(current);
            Matcher matcher = ((Pattern)this.locationPatternMap.get(current)).matcher(toMatch);
            if (matcher.matches()) continue;
            return false;
        }
        return true;
    }

    public static String escapeDots(String patternWithDots) {
        Validate.notEmpty((CharSequence)patternWithDots, (String)"Cannot handle null or empty patternWithDots argument.", (Object[])new Object[0]);
        return patternWithDots.replaceAll("\\.", "\\\\.");
    }

    public static String getPattern(Package thePackage, boolean includeSubPackages) {
        Validate.notNull((Object)thePackage, (String)"Cannot handle null thePackage argument.", (Object[])new Object[0]);
        String exactPackagePattern = SourceLocationFilter.escapeDots(thePackage.getName());
        return includeSubPackages ? exactPackagePattern + "(\\.\\w*)*" : exactPackagePattern;
    }

    private void setupInternalState(LocationScope scope) {
        this.locationPatternMap = new TreeMap<LocationScope, Pattern>();
        this.acceptAllInProject = scope == LocationScope.PROJECT;
        this.scope = scope;
    }

    private void compilePattern(LocationScope location, String javaRegExp) {
        Validate.notEmpty((CharSequence)javaRegExp, (String)("Cannot handle null or empty " + location.toString().toLowerCase() + " scope java regexp."), (Object[])new Object[0]);
        this.locationPatternMap.put(location, Pattern.compile(javaRegExp));
    }
}

