/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.metrics.api;

import net.sourceforge.cobertura.metrics.api.CoverageCalculator;
import net.sourceforge.cobertura.metrics.api.CoverageType;
import net.sourceforge.cobertura.metrics.api.location.SourceLocationFilter;
import net.sourceforge.cobertura.metrics.model.coverage.Rate;
import org.apache.commons.lang3.Validate;

public abstract class AbstractCoverageCalculator
implements CoverageCalculator {
    @Override
    public final Rate getCoverageRate(SourceLocationFilter filter, CoverageType type) {
        Validate.notNull((Object)((Object)type), (String)"Cannot handle null type argument.", (Object[])new Object[0]);
        Validate.notNull((Object)filter, (String)"Cannot handle null filter argument.", (Object[])new Object[0]);
        return this.getRate(filter, type);
    }

    protected abstract Rate getRate(SourceLocationFilter var1, CoverageType var2);

    @Override
    public final double getCoverage(SourceLocationFilter filter, CoverageType type) {
        Rate coverageRate = this.getCoverageRate(filter, type);
        if (coverageRate == null) {
            return 0.0;
        }
        return (double)coverageRate.getActual() / (double)coverageRate.getMaximum();
    }
}

