/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ccxjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import net.sourceforge.ccxjc.ClassOutlineComparator;
import net.sourceforge.ccxjc.JClassComparator;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginImpl
extends Plugin {
    private static final JType[] NO_ARGS = new JType[0];
    private static final Class[] NO_PARAMS = new Class[0];
    private static final String MESSAGE_PREFIX = "CC-XJC";
    private static final String[] IMMUTABLE_NAMES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.util.UUID"};
    private boolean success;
    private Options options;

    public String getOptionName() {
        return "copy-constructor";
    }

    public String getUsage() {
        return this.getMessage("usage", null);
    }

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        this.success = true;
        this.options = options;
        this.log(Level.INFO, "title", null);
        for (ClassOutline clazz : model.getClasses()) {
            if (this.getStandardConstructor(clazz) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", new Object[]{clazz.implClass.binaryName()});
            }
            if (this.getCopyConstructor(clazz) != null) continue;
            this.log(Level.WARNING, "couldNotAddCopyCtor", new Object[]{clazz.implClass.binaryName()});
        }
        for (ClassOutline clazz : model.getClasses()) {
            if (this.getCloneMethod(clazz) != null) continue;
            this.log(Level.WARNING, "couldNotAddMethod", new Object[]{"clone", clazz.implClass.binaryName()});
        }
        return this.success;
    }

    private ClassOutline getClassOutline(Outline outline, String binaryName) {
        for (ClassOutline c : outline.getClasses()) {
            if (!c.implClass.binaryName().equals(binaryName)) continue;
            return c;
        }
        return null;
    }

    private EnumOutline getEnumOutline(Outline outline, String binaryName) {
        for (EnumOutline e : outline.getEnums()) {
            if (!e.clazz.binaryName().equals(binaryName)) continue;
            return e;
        }
        return null;
    }

    private JClass getSupertype(List<JClass> superTypes, JClass clazz) {
        JClass superType = null;
        if (clazz._extends() != null) {
            superType = this.getSupertype(superTypes, clazz._extends());
        }
        if (superType == null) {
            for (JClass c : superTypes) {
                if (!c.binaryName().equals(clazz.binaryName())) continue;
                superType = clazz;
                break;
            }
        }
        return superType;
    }

    private ClassOutline getSuperclass(List<ClassOutline> superClasses, ClassOutline clazz) {
        ClassOutline superClass = null;
        if (clazz.getSuperClass() != null) {
            superClass = this.getSuperclass(superClasses, clazz.getSuperClass());
        }
        if (superClass == null) {
            for (ClassOutline c : superClasses) {
                if (!c.implClass.binaryName().equals(clazz.implClass.binaryName())) continue;
                superClass = clazz;
                break;
            }
        }
        return superClass;
    }

    private JMethod getPropertyGetter(FieldOutline f) {
        JDefinedClass clazz = f.parent().implClass;
        String name = f.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private boolean isPropertyField(ClassOutline clazz, String fieldName) {
        for (FieldOutline f : clazz.getDeclaredFields()) {
            if (!f.getPropertyInfo().getName(false).equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean isImmutableType(JType type) {
        for (String s : IMMUTABLE_NAMES) {
            if (!type.binaryName().equals(s)) continue;
            return true;
        }
        return false;
    }

    private JMethod getCloneMethod(ClassOutline clazz) {
        JMethod clone = clazz.implClass.getMethod("clone", NO_ARGS);
        if (clone == null) {
            clone = this.generateCloneMethod(clazz);
        } else {
            this.log(Level.WARNING, "methodExists", new Object[]{"clone", clazz.implClass.binaryName()});
        }
        return clone;
    }

    private JMethod getStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[]{clazz.implClass.binaryName()});
        }
        return ctor;
    }

    private JMethod getCopyConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.getConstructor(new JType[]{clazz.implClass});
        if (ctor == null) {
            ctor = this.generateCopyConstructor(clazz);
        } else {
            this.log(Level.WARNING, "copyCtorExists", new Object[]{clazz.implClass.binaryName()});
        }
        return ctor;
    }

    private JMethod generateCloneMethod(ClassOutline clazz) {
        JMethod cloneMethod = null;
        if (clazz.implClass.isAbstract()) {
            cloneMethod = clazz.implClass.method(33, (JType)clazz.implClass, "clone");
        } else {
            cloneMethod = clazz.implClass.method(1, (JType)clazz.implClass, "clone");
            cloneMethod.body().directStatement(" // " + this.getMessage("title", null));
            cloneMethod.body()._return((JExpression)JExpr._new((JClass)clazz.implClass).arg(JExpr._this()));
        }
        cloneMethod.annotate(Override.class);
        clazz.implClass._implements(clazz.parent().getCodeModel().ref(Cloneable.class));
        cloneMethod.javadoc().append((Object)"Creates and returns a copy of this object.\n");
        cloneMethod.javadoc().addReturn().append((Object)"A clone of this instance.");
        return cloneMethod;
    }

    private JMethod generateStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.constructor(1);
        ctor.body().directStatement(" // " + this.getMessage("title", null));
        ctor.body().invoke("super");
        ctor.javadoc().add((Object)("Creates a new {@code " + clazz.implClass.fullName() + "} instance."));
        return ctor;
    }

    private JMethod generateCopyConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.constructor(1);
        JVar o = ctor.param(8, (JType)clazz.implClass, "o");
        ctor.javadoc().add((Object)("Creates a new {@code " + clazz.implClass.fullName() + "} instance by copying a given instance."));
        ctor.javadoc().addParam(o).add((Object)"The instance to copy or {@code null}.");
        ctor.body().directStatement(" // " + this.getMessage("title", null));
        if (clazz.getSuperClass() != null) {
            ctor.body().invoke("super").arg((JExpression)o);
        } else {
            ctor.body().invoke("super");
        }
        JConditional paramNotNull = ctor.body()._if(o.ne(JExpr._null()));
        for (FieldOutline field : clazz.getDeclaredFields()) {
            this.generateCopyProperty(field, o, paramNotNull._then());
        }
        for (JFieldVar field : clazz.implClass.fields().values()) {
            if (this.isPropertyField(clazz, field.name()) || (field.mods().getValue() & 0x10) == 16) continue;
            this.generateCopyField(clazz, field, o, paramNotNull._then());
        }
        return ctor;
    }

    private void generateCopyProperty(FieldOutline field, JVar o, JBlock block) {
        JMethod getter = this.getPropertyGetter(field);
        JClass object = field.parent().parent().getCodeModel().ref(Object.class);
        JClass assertionErrorType = field.parent().parent().getCodeModel().ref(AssertionError.class);
        if (getter != null) {
            if (field.getPropertyInfo().isCollection()) {
                block.directStatement("// Property '" + field.getPropertyInfo().getName(true) + "'.");
                LinkedList refTypes = new LinkedList(field.getPropertyInfo().ref() != null ? field.getPropertyInfo().ref() : Collections.EMPTY_LIST);
                if (!refTypes.isEmpty()) {
                    LinkedList<JClass> allTypes = new LinkedList<JClass>();
                    for (CTypeInfo t : refTypes) {
                        JClass javaType;
                        String typeName = t.toType(field.parent().parent(), Aspect.EXPOSED).binaryName();
                        int idx = typeName.indexOf(60);
                        if (idx != -1) {
                            typeName = typeName.substring(0, idx);
                        }
                        if (allTypes.contains(javaType = field.parent().parent().getCodeModel().ref(typeName))) continue;
                        allTypes.add(javaType);
                    }
                    JForLoop copyLoop = block._for();
                    JVar it = copyLoop.init((JType)field.parent().parent().getCodeModel().ref(Iterator.class), "it", (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter).invoke("iterator"));
                    copyLoop.test((JExpression)JExpr.invoke((JExpression)it, (String)"hasNext"));
                    JVar next = copyLoop.body().decl((JType)object, "next", (JExpression)JExpr.invoke((JExpression)it, (String)"next"));
                    LinkedList<ClassOutline> allClasses = new LinkedList<ClassOutline>();
                    Iterator t = refTypes.iterator();
                    while (t.hasNext()) {
                        JType copy = ((CTypeInfo)t.next()).toType(field.parent().parent(), Aspect.EXPOSED);
                        ClassOutline ref = this.getClassOutline(field.parent().parent(), copy.binaryName());
                        if (ref == null) continue;
                        if (!allClasses.contains(ref)) {
                            allClasses.add(ref);
                        }
                        t.remove();
                    }
                    LinkedList<ClassOutline> superClasses = new LinkedList<ClassOutline>();
                    for (ClassOutline c : allClasses) {
                        ClassOutline superClass = this.getSuperclass(allClasses, c);
                        if (superClasses.contains(superClass)) continue;
                        superClasses.add(superClass);
                    }
                    Collections.sort(superClasses, new ClassOutlineComparator());
                    for (ClassOutline refClass : superClasses) {
                        copyLoop.body().directStatement("// Cloneable reference '" + refClass.implClass.binaryName() + "'.");
                        JConditional ifInstance = copyLoop.body()._if(next._instanceof((JType)refClass.implClass));
                        ifInstance._then().invoke((JExpression)JExpr.invoke((JMethod)getter), "add").arg((JExpression)JExpr.cast((JType)refClass.implClass, (JExpression)JExpr.invoke((JExpression)JExpr.cast((JType)refClass.implClass, (JExpression)JExpr.ref((String)"next")), (String)"clone")));
                        ifInstance._then()._continue();
                    }
                    LinkedList<JClass> superTypes = new LinkedList<JClass>();
                    for (CTypeInfo type : refTypes) {
                        JClass javaType;
                        JClass superType;
                        String typeName = type.toType(field.parent().parent(), Aspect.EXPOSED).binaryName();
                        int idx = typeName.indexOf(60);
                        if (idx != -1) {
                            typeName = typeName.substring(0, idx);
                        }
                        if (superTypes.contains(superType = this.getSupertype(allTypes, javaType = field.parent().parent().getCodeModel().ref(typeName)))) continue;
                        superTypes.add(superType);
                    }
                    Collections.sort(superTypes, new JClassComparator());
                    Iterator t2 = superTypes.iterator();
                    while (t2.hasNext()) {
                        JType refType = (JType)t2.next();
                        JConditional ifInstance = copyLoop.body()._if(next._instanceof(refType));
                        if (!this.isCloneable(refType)) {
                            ifInstance._then().directStatement("// Immutable type '" + refType.binaryName() + "'.");
                            ifInstance._then().invoke((JExpression)JExpr.invoke((JMethod)getter), "add").arg((JExpression)JExpr.cast((JType)refType, (JExpression)next));
                            ifInstance._then()._continue();
                            if (!this.isImmutableType(refType)) continue;
                            t2.remove();
                            continue;
                        }
                        ifInstance._then().directStatement("// Cloneable type '" + refType.binaryName() + "'.");
                        JBlock cloneBlock = ifInstance._then();
                        if (this.isThrowingCloneNotSupportedException(refType)) {
                            JTryBlock tryCloneable = cloneBlock._try();
                            JCatchBlock catchCloneNotSupported = tryCloneable._catch(field.parent().parent().getCodeModel().ref(CloneNotSupportedException.class));
                            catchCloneNotSupported.body()._throw((JExpression)JExpr._new((JType)field.parent().parent().getCodeModel()._ref(AssertionError.class)).arg((JExpression)catchCloneNotSupported.param("e")));
                            cloneBlock = tryCloneable.body();
                        }
                        cloneBlock.invoke((JExpression)JExpr.invoke((JMethod)getter), "add").arg((JExpression)JExpr.cast((JType)refType, (JExpression)JExpr.invoke((JExpression)JExpr.cast((JType)refType, (JExpression)next), (String)"clone")));
                        t2.remove();
                    }
                    copyLoop.body()._throw((JExpression)JExpr._new((JClass)assertionErrorType).arg(JExpr.lit((String)"Unexpected instance '").plus((JExpression)next).plus(JExpr.lit((String)("' for property '" + field.getPropertyInfo().getName(true) + "' of class '" + field.parent().implClass.binaryName() + "'.")))));
                    if (!superTypes.isEmpty()) {
                        this.log(Level.WARNING, "cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()});
                    }
                } else {
                    this.log(Level.SEVERE, "typesNotFound", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()});
                    this.success = false;
                }
            } else {
                ClassOutline ref = this.getClassOutline(field.parent().parent(), field.getRawType().binaryName());
                if (ref != null) {
                    block.directStatement("// Property '" + field.getPropertyInfo().getName(true) + "'.");
                    JConditional notnull = block._if(JExpr.invoke((JExpression)o, (JMethod)getter).ne(JExpr._null()));
                    notnull._then().directStatement("// Cloneable reference '" + ref.implClass.binaryName() + "'.");
                    notnull._then().assign((JAssignmentTarget)JExpr.refthis((String)field.getPropertyInfo().getName(false)), (JExpression)JExpr.cast((JType)ref.implClass, (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter).invoke("clone")));
                    notnull._else().assign((JAssignmentTarget)JExpr.refthis((String)field.getPropertyInfo().getName(false)), JExpr._null());
                } else {
                    EnumOutline enumOutline = this.getEnumOutline(field.parent().parent(), field.getRawType().binaryName());
                    if (field.getRawType().isPrimitive() || enumOutline != null || !this.isCloneable(field.getRawType())) {
                        block.directStatement("// Immutable property '" + field.getPropertyInfo().getName(true) + "' of type '" + field.getRawType().binaryName() + "'.");
                        block.assign((JAssignmentTarget)JExpr.refthis((String)field.getPropertyInfo().getName(false)), (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter));
                        if (!field.getRawType().isPrimitive() && enumOutline == null && !this.isImmutableType(field.getRawType())) {
                            this.log(Level.WARNING, "cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()});
                        }
                    } else {
                        block.directStatement("// Cloneable property '" + field.getPropertyInfo().getName(true) + "' of type '" + field.getRawType().binaryName() + "'.");
                        JConditional notnull = null;
                        if (this.isThrowingCloneNotSupportedException(field.getRawType())) {
                            JTryBlock tryCloneable = block._try();
                            JCatchBlock catchCloneNotSupported = tryCloneable._catch(field.parent().parent().getCodeModel().ref(CloneNotSupportedException.class));
                            catchCloneNotSupported.body()._throw((JExpression)JExpr._new((JType)field.parent().parent().getCodeModel()._ref(AssertionError.class)).arg((JExpression)catchCloneNotSupported.param("e")));
                            notnull = tryCloneable.body()._if(JExpr.invoke((JExpression)o, (JMethod)getter).ne(JExpr._null()));
                        } else {
                            notnull = block._if(JExpr.invoke((JExpression)o, (JMethod)getter).ne(JExpr._null()));
                        }
                        notnull._then().assign((JAssignmentTarget)JExpr.refthis((String)field.getPropertyInfo().getName(false)), (JExpression)JExpr.cast((JType)field.getRawType(), (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter).invoke("clone")));
                        notnull._else().assign((JAssignmentTarget)JExpr.refthis((String)field.getPropertyInfo().getName(false)), JExpr._null());
                    }
                }
            }
        } else {
            this.log(Level.SEVERE, "getterNotFound", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()});
            this.success = false;
        }
    }

    private void generateCopyField(ClassOutline clazz, JFieldVar field, JVar o, JBlock block) {
        if (!field.type().isPrimitive() && this.isCloneable(field.type())) {
            block.directStatement("// Cloneable field '" + field.name() + "'.");
            JConditional refNotNull = null;
            if (this.isThrowingCloneNotSupportedException(field.type())) {
                JTryBlock tryClone = block._try();
                JCatchBlock cloneNotSupported = tryClone._catch(clazz.parent().getCodeModel().ref(CloneNotSupportedException.class));
                cloneNotSupported.body()._throw((JExpression)JExpr._new((JClass)clazz.parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)cloneNotSupported.param("e")));
                refNotNull = tryClone.body()._if(JExpr.ref((JExpression)o, (JVar)field).ne(JExpr._null()));
            } else {
                refNotNull = block._if(JExpr.ref((JExpression)o, (JVar)field).ne(JExpr._null()));
            }
            refNotNull._then().assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)JExpr.cast((JType)field.type(), (JExpression)JExpr.ref((JExpression)o, (JVar)field).invoke("clone")));
            refNotNull._else().assign((JAssignmentTarget)JExpr.refthis((String)field.name()), JExpr._null());
        } else {
            block.directStatement("// Immutable field '" + field.name() + "'.");
            block.assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)JExpr.ref((JExpression)o, (JVar)field));
            if (!field.type().isPrimitive() && !this.isImmutableType(field.type()) && this.getEnumOutline(clazz.parent(), field.type().binaryName()) == null) {
                this.log(Level.WARNING, "cannotCopyField", new Object[]{field.name(), clazz.implClass.binaryName()});
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private boolean isCloneable(JType type) {
        try {
            return Cloneable.class.isAssignableFrom(Class.forName(type.binaryName(), false, this.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            this.log(Level.WARNING, "classNotFound", new Object[]{e.getMessage()});
            return false;
        }
    }

    private boolean isThrowingCloneNotSupportedException(JType type) {
        try {
            Class<?> clazz = Class.forName(type.binaryName(), false, this.getClassLoader());
            Method clone = clazz.getMethod("clone", NO_PARAMS);
            for (Class<?> e : clone.getExceptionTypes()) {
                if (!CloneNotSupportedException.class.isAssignableFrom(e)) continue;
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            this.log(Level.WARNING, "methodNotFound", new Object[]{e.getMessage()});
        }
        catch (ClassNotFoundException e) {
            this.log(Level.WARNING, "classNotFound", new Object[]{e.getMessage()});
        }
        return false;
    }

    private String getMessage(String key, Object args) {
        ResourceBundle bundle = ResourceBundle.getBundle("net/sourceforge/ccxjc/PluginImpl");
        return new MessageFormat(bundle.getString(key)).format(args);
    }

    private void log(Level level, String key, Object args) {
        StringBuffer b = new StringBuffer().append("[").append(MESSAGE_PREFIX).append("] [").append(level).append("] ").append(this.getMessage(key, args));
        if (this.options != null && !this.options.quiet) {
            int l;
            int n = l = this.options != null && this.options.debugMode ? Level.ALL.intValue() : Level.INFO.intValue();
            if (level.intValue() >= l) {
                if (level.intValue() <= Level.INFO.intValue()) {
                    System.out.println(b.toString());
                } else {
                    System.err.println(b.toString());
                }
            }
        }
    }
}

