/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ccxjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CArrayInfo;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.CWildcardTypeInfo;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.sourceforge.ccxjc.CClassInfoComparator;
import net.sourceforge.ccxjc.CElementInfoComparator;
import net.sourceforge.ccxjc.CTypeInfoComparator;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public final class PluginImpl
extends Plugin {
    private static final JType[] NO_ARGS = new JType[0];
    private static final String MESSAGE_PREFIX = "CC-XJC";
    private static final String OPTION_NAME = "copy-constructor";
    private static final String VISIBILITY_OPTION_NAME = "-cc-visibility";
    private static final String TARGET_OPTION_NAME = "-cc-target";
    private static final Class[] IMMUTABLE_TYPES = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Enum.class, Float.class, Integer.class, Long.class, Short.class, String.class, BigDecimal.class, BigInteger.class, UUID.class, QName.class, Duration.class, Currency.class};
    private static final Class[] CLONEABLE_TYPES = new Class[]{XMLGregorianCalendar.class, Date.class, Calendar.class, TimeZone.class, Locale.class};
    private static final Class[] PRIMITIVE_ARRAY_TYPES = new Class[]{boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class};
    private static final String[] VISIBILITY_ARGUMENTS = new String[]{"private", "package", "protected", "public"};
    private static final String[] TARGET_ARGUMENTS = new String[]{"1.5", "1.6", "1.7"};
    private static final int TARGET_1_5 = 5;
    private static final int TARGET_1_6 = 6;
    private static final int TARGET_1_7 = 7;
    private boolean success;
    private Options options;
    private String visibility = "private";
    private int targetJdk = 5;
    private BigInteger methodCount;
    private BigInteger constructorCount;
    private BigInteger expressionCount;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return new StringBuffer().append("  -").append(OPTION_NAME).append("  :  ").append(this.getMessage("usage", null)).append(System.getProperty("line.separator")).append("  ").append(VISIBILITY_OPTION_NAME).append("     :  ").append(this.getMessage("visibilityUsage", null)).append(System.getProperty("line.separator")).append("  ").append(TARGET_OPTION_NAME).append("         :  ").append(this.getMessage("targetUsage", null)).toString();
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        String missingOptionArgument;
        StringBuffer supportedVisibilities = new StringBuffer().append('[');
        Iterator<String> it = Arrays.asList(VISIBILITY_ARGUMENTS).iterator();
        while (it.hasNext()) {
            supportedVisibilities.append(it.next());
            if (!it.hasNext()) continue;
            supportedVisibilities.append(", ");
        }
        StringBuffer supportedTargets = new StringBuffer().append('[');
        Iterator<String> it2 = Arrays.asList(TARGET_ARGUMENTS).iterator();
        while (it2.hasNext()) {
            supportedTargets.append(it2.next());
            if (!it2.hasNext()) continue;
            supportedTargets.append(", ");
        }
        if (args[i].startsWith(VISIBILITY_OPTION_NAME)) {
            if (i + 1 >= args.length) {
                missingOptionArgument = this.getMessage("missingOptionArgument", new Object[]{VISIBILITY_OPTION_NAME});
                String expectedOptionArgument = this.getMessage("expectedOptionArgument", new Object[]{supportedVisibilities.append(']').toString()});
                throw new BadCommandLineException(missingOptionArgument + " " + expectedOptionArgument);
            }
            this.visibility = args[i + 1].trim();
            boolean supported = false;
            for (String argument : VISIBILITY_ARGUMENTS) {
                if (!argument.equals(this.visibility)) continue;
                supported = true;
                break;
            }
            if (!supported) {
                String expectedOptionArgument = this.getMessage("expectedOptionArgument", new Object[]{supportedVisibilities.append(']').toString()});
                throw new BadCommandLineException(expectedOptionArgument);
            }
            return 2;
        }
        if (args[i].startsWith(TARGET_OPTION_NAME)) {
            if (i + 1 >= args.length) {
                missingOptionArgument = this.getMessage("missingOptionArgument", new Object[]{TARGET_OPTION_NAME});
                String expectedOptionArgument = this.getMessage("expectedOptionArgument", new Object[]{supportedTargets.append(']').toString()});
                throw new BadCommandLineException(missingOptionArgument + " " + expectedOptionArgument);
            }
            String targetArg = args[i + 1].trim();
            boolean supported = false;
            for (String argument : TARGET_ARGUMENTS) {
                if (!argument.equals(targetArg)) continue;
                supported = true;
                break;
            }
            if (!supported) {
                String expectedOptionArgument = this.getMessage("expectedOptionArgument", new Object[]{supportedTargets.append(']').toString()});
                throw new BadCommandLineException(expectedOptionArgument);
            }
            if (targetArg.equals("1.5")) {
                this.targetJdk = 5;
            } else if (targetArg.equals("1.6")) {
                this.targetJdk = 6;
            } else if (targetArg.equals("1.7")) {
                this.targetJdk = 7;
            }
            return 2;
        }
        return 0;
    }

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        this.success = true;
        this.options = options;
        this.methodCount = BigInteger.ZERO;
        this.constructorCount = BigInteger.ZERO;
        this.expressionCount = BigInteger.ZERO;
        this.log(Level.INFO, "title", null);
        this.log(Level.INFO, "visibilityReport", new Object[]{this.visibility});
        for (ClassOutline clazz : model.getClasses()) {
            if (this.getStandardConstructor(clazz) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", new Object[]{clazz.implClass.binaryName()});
            }
            if (this.getCopyConstructor(clazz) == null) {
                this.log(Level.WARNING, "couldNotAddCopyCtor", new Object[]{clazz.implClass.binaryName()});
            }
            if (this.getCloneMethod(clazz) != null) continue;
            this.log(Level.WARNING, "couldNotAddMethod", new Object[]{"clone", clazz.implClass.binaryName()});
        }
        this.log(Level.INFO, "report", new Object[]{this.methodCount, this.constructorCount, this.expressionCount});
        return this.success;
    }

    private int getVisibilityModifier() {
        if ("private".equals(this.visibility)) {
            return 4;
        }
        if ("protected".equals(this.visibility)) {
            return 2;
        }
        if ("public".equals(this.visibility)) {
            return 1;
        }
        return 0;
    }

    private boolean isTargetSupported(int target) {
        return target <= this.targetJdk;
    }

    private JMethod getStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[]{clazz.implClass.binaryName()});
        }
        return ctor;
    }

    private JMethod getCopyConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.getConstructor(new JType[]{clazz.implClass});
        if (ctor == null) {
            ctor = this.generateCopyConstructor(clazz);
        } else {
            this.log(Level.WARNING, "copyCtorExists", new Object[]{clazz.implClass.binaryName()});
        }
        return ctor;
    }

    private JMethod getCloneMethod(ClassOutline clazz) {
        JMethod clone = clazz.implClass.getMethod("clone", NO_ARGS);
        if (clone == null) {
            clone = this.generateCloneMethod(clazz);
        } else {
            this.log(Level.WARNING, "methodExists", new Object[]{"clone", clazz.implClass.binaryName()});
        }
        return clone;
    }

    private JMethod getPropertyGetter(FieldOutline f) {
        JDefinedClass clazz = f.parent().implClass;
        String name = f.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private FieldOutline getFieldOutline(ClassOutline clazz, String fieldName) {
        for (FieldOutline f : clazz.getDeclaredFields()) {
            if (!f.getPropertyInfo().getName(false).equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    private JInvocation getCopyOfJaxbElementInvocation(ClassOutline clazz) {
        JClass jaxbElement = clazz.parent().getCodeModel().ref(JAXBElement.class);
        JType[] signature = new JType[]{jaxbElement};
        String methodName = "copyOFJAXBElement";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOFJAXBElement") || !m.hasSignature(signature)) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOFJAXBElement") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, JAXBElement.class, "copyOFJAXBElement") : clazz.implClass.method(0x10 | mod, JAXBElement.class, "copyOFJAXBElement");
        JVar element = m.param(8, (JType)jaxbElement, "element");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given {@code JAXBElement} instance.");
        m.javadoc().addParam(element).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code element} or {@code null} if {@code element} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional isNotNull = m.body()._if(element.ne(JExpr._null()));
        JInvocation newElement = JExpr._new((JClass)jaxbElement).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getName")).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getDeclaredType")).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getScope")).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getValue"));
        JVar copy = isNotNull._then().decl(8, (JType)jaxbElement, "copy", (JExpression)newElement);
        isNotNull._then().add((JStatement)copy.invoke("setNil").arg((JExpression)element.invoke("isNil")));
        isNotNull._then().add((JStatement)copy.invoke("setValue").arg((JExpression)this.getCopyOfObjectInvocation(clazz).arg((JExpression)JExpr.invoke((JExpression)copy, (String)"getValue"))));
        isNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JExpression getCopyOfPrimitiveArrayExpression(ClassOutline classOutline, JClass arrayType, JExpression source) {
        JType[] signature;
        if (this.isTargetSupported(6)) {
            JClass arrays = classOutline.parent().getCodeModel().ref(Arrays.class);
            return JOp.cond((JExpression)source.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)arrays.staticInvoke("copyOf").arg(source).arg((JExpression)source.ref("length")));
        }
        JClass array = classOutline.parent().getCodeModel().ref(Array.class);
        JClass system = classOutline.parent().getCodeModel().ref(System.class);
        int mod = this.getVisibilityModifier();
        String methodName = "copyOf";
        if (mod != 4) {
            for (JMethod m : classOutline._package().objectFactory().methods()) {
                if (!m.name().equals("copyOf") || (signature = m.listParamTypes()).length != 1 || !signature[0].binaryName().equals(arrayType.binaryName())) continue;
                return classOutline._package().objectFactory().staticInvoke(m).arg(source);
            }
        } else {
            for (JMethod m : classOutline.implClass.methods()) {
                if (!m.name().equals("copyOf") || (signature = m.listParamTypes()).length != 1 || !signature[0].binaryName().equals(arrayType.binaryName())) continue;
                return JExpr.invoke((JMethod)m).arg(source);
            }
        }
        JMethod m = mod != 4 ? classOutline._package().objectFactory().method(0x10 | mod, (JType)arrayType, "copyOf") : classOutline.implClass.method(0x10 | mod, (JType)arrayType, "copyOf");
        JVar arrayParam = m.param(8, (JType)arrayType, "array");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given array.");
        m.javadoc().addParam(arrayParam).append((Object)"The array to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code array} or {@code null} if {@code array} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional arrayNotNull = m.body()._if(arrayParam.ne(JExpr._null()));
        JVar copy = arrayNotNull._then().decl(8, (JType)arrayType, "copy", (JExpression)JExpr.cast((JType)arrayType, (JExpression)array.staticInvoke("newInstance").arg((JExpression)arrayParam.invoke("getClass").invoke("getComponentType")).arg((JExpression)arrayParam.ref("length"))));
        arrayNotNull._then().add((JStatement)system.staticInvoke("arraycopy").arg((JExpression)arrayParam).arg(JExpr.lit((int)0)).arg((JExpression)copy).arg(JExpr.lit((int)0)).arg((JExpression)arrayParam.ref("length")));
        arrayNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? classOutline._package().objectFactory().staticInvoke(m).arg(source) : JExpr.invoke((JMethod)m).arg(source);
    }

    private JInvocation getCopyOfArrayInvocation(ClassOutline clazz) {
        JClass object = clazz.parent().getCodeModel().ref(Object.class);
        JClass array = clazz.parent().getCodeModel().ref(Array.class);
        JType[] signature = new JType[]{object};
        String methodName = "copyOfArray";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOfArray") || !m.hasSignature(signature)) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOfArray") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, (JType)object, "copyOfArray") : clazz.implClass.method(0x10 | mod, (JType)object, "copyOfArray");
        JVar arrayArg = m.param(8, (JType)object, "array");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given array.");
        m.javadoc().addParam(arrayArg).append((Object)"The array to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code array} or {@code null} if {@code array} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional arrayNotNull = m.body()._if(arrayArg.ne(JExpr._null()));
        for (Class a : PRIMITIVE_ARRAY_TYPES) {
            JClass primitiveArray = clazz.parent().getCodeModel().ref(a);
            JConditional isArrayOfPrimitive = arrayNotNull._then()._if(arrayArg.invoke("getClass").eq(primitiveArray.dotclass()));
            isArrayOfPrimitive._then()._return(this.getCopyOfPrimitiveArrayExpression(clazz, primitiveArray, (JExpression)JExpr.cast((JType)primitiveArray, (JExpression)arrayArg)));
        }
        JVar len = arrayNotNull._then().decl(8, (JType)clazz.parent().getCodeModel().INT, "len", (JExpression)array.staticInvoke("getLength").arg((JExpression)arrayArg));
        JVar copy = arrayNotNull._then().decl(8, (JType)object, "copy", (JExpression)array.staticInvoke("newInstance").arg((JExpression)arrayArg.invoke("getClass").invoke("getComponentType")).arg((JExpression)len));
        JForLoop forEachRef = arrayNotNull._then()._for();
        JVar i = forEachRef.init((JType)clazz.parent().getCodeModel().INT, "i", len.minus(JExpr.lit((int)1)));
        forEachRef.test(i.gte(JExpr.lit((int)0)));
        forEachRef.update(i.decr());
        forEachRef.body().add((JStatement)array.staticInvoke("set").arg((JExpression)copy).arg((JExpression)i).arg((JExpression)this.getCopyOfObjectInvocation(clazz).arg((JExpression)array.staticInvoke("get").arg((JExpression)arrayArg).arg((JExpression)i))));
        arrayNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfSerializableInvocation(ClassOutline clazz) {
        JClass serializable = clazz.parent().getCodeModel().ref(Serializable.class);
        JClass byteArrayOutputStream = clazz.parent().getCodeModel().ref(ByteArrayOutputStream.class);
        JClass byteArrayInputStream = clazz.parent().getCodeModel().ref(ByteArrayInputStream.class);
        JClass objectOutputStream = clazz.parent().getCodeModel().ref(ObjectOutputStream.class);
        JClass objectInputStream = clazz.parent().getCodeModel().ref(ObjectInputStream.class);
        JClass ioException = clazz.parent().getCodeModel().ref(IOException.class);
        JClass invalidClass = clazz.parent().getCodeModel().ref(InvalidClassException.class);
        JClass notSerializable = clazz.parent().getCodeModel().ref(NotSerializableException.class);
        JClass streamCorrupted = clazz.parent().getCodeModel().ref(StreamCorruptedException.class);
        JClass securityException = clazz.parent().getCodeModel().ref(SecurityException.class);
        JClass optionalData = clazz.parent().getCodeModel().ref(OptionalDataException.class);
        JClass classNotFound = clazz.parent().getCodeModel().ref(ClassNotFoundException.class);
        JClass assertionError = clazz.parent().getCodeModel().ref(AssertionError.class);
        JType[] signature = new JType[]{serializable};
        String methodName = "copyOfSerializable";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOfSerializable") || !m.hasSignature(signature)) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOfSerializable") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, (JType)serializable, "copyOfSerializable") : clazz.implClass.method(0x10 | mod, (JType)serializable, "copyOfSerializable");
        JVar s = m.param(8, (JType)serializable, "serializable");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given {@code Serializable}.");
        m.javadoc().addParam(s).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code serializable} or {@code null} if {@code serializable} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional sNotNull = m.body()._if(s.ne(JExpr._null()));
        JTryBlock tryClone = sNotNull._then()._try();
        JVar byteArrayOutput = tryClone.body().decl(8, (JType)byteArrayOutputStream, "byteArrayOutput", (JExpression)JExpr._new((JClass)byteArrayOutputStream));
        JVar objectOutput = tryClone.body().decl(8, (JType)objectOutputStream, "out", (JExpression)JExpr._new((JClass)objectOutputStream).arg((JExpression)byteArrayOutput));
        tryClone.body().add((JStatement)objectOutput.invoke("writeObject").arg((JExpression)s));
        tryClone.body().add((JStatement)objectOutput.invoke("close"));
        JVar byteArrayInput = tryClone.body().decl(8, (JType)byteArrayInputStream, "byteArrayInput", (JExpression)JExpr._new((JClass)byteArrayInputStream).arg((JExpression)byteArrayOutput.invoke("toByteArray")));
        JVar objectInput = tryClone.body().decl(8, (JType)objectInputStream, "in", (JExpression)JExpr._new((JClass)objectInputStream).arg((JExpression)byteArrayInput));
        JVar copy = tryClone.body().decl(8, (JType)serializable, "copy", (JExpression)JExpr.cast((JType)serializable, (JExpression)objectInput.invoke("readObject")));
        tryClone.body().invoke((JExpression)objectInput, "close");
        tryClone.body()._return((JExpression)copy);
        JExpression assertionErrorMsg = JExpr.lit((String)"Unexpected instance during copying object '").plus((JExpression)s).plus(JExpr.lit((String)"'."));
        JCatchBlock catchSecurityException = tryClone._catch(securityException);
        catchSecurityException.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchSecurityException.param("e"))));
        JCatchBlock catchClassNotFound = tryClone._catch(classNotFound);
        catchClassNotFound.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchClassNotFound.param("e"))));
        JCatchBlock catchInvalidClass = tryClone._catch(invalidClass);
        catchInvalidClass.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchInvalidClass.param("e"))));
        JCatchBlock catchNotSerializable = tryClone._catch(notSerializable);
        catchNotSerializable.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchNotSerializable.param("e"))));
        JCatchBlock catchStreamCorrupted = tryClone._catch(streamCorrupted);
        catchStreamCorrupted.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchStreamCorrupted.param("e"))));
        JCatchBlock catchOptionalData = tryClone._catch(optionalData);
        catchOptionalData.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchOptionalData.param("e"))));
        JCatchBlock catchIOException = tryClone._catch(ioException);
        catchIOException.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchIOException.param("e"))));
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfObjectInvocation(ClassOutline clazz) {
        JClass object = clazz.parent().getCodeModel().ref(Object.class);
        JClass element = clazz.parent().getCodeModel().ref(Element.class);
        JClass jaxbElement = clazz.parent().getCodeModel().ref(JAXBElement.class);
        JClass noSuchMethod = clazz.parent().getCodeModel().ref(NoSuchMethodException.class);
        JClass illegalAccess = clazz.parent().getCodeModel().ref(IllegalAccessException.class);
        JClass invocationTarget = clazz.parent().getCodeModel().ref(InvocationTargetException.class);
        JClass securityException = clazz.parent().getCodeModel().ref(SecurityException.class);
        JClass illegalArgument = clazz.parent().getCodeModel().ref(IllegalArgumentException.class);
        JClass initializerError = clazz.parent().getCodeModel().ref(ExceptionInInitializerError.class);
        JClass assertionError = clazz.parent().getCodeModel().ref(AssertionError.class);
        JClass classArray = clazz.parent().getCodeModel().ref(Class[].class);
        JClass objectArray = clazz.parent().getCodeModel().ref(Object[].class);
        JClass serializable = clazz.parent().getCodeModel().ref(Serializable.class);
        String methodName = "copyOfObject";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOfObject")) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOfObject")) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, (JType)object, "copyOfObject") : clazz.implClass.method(0x10 | mod, (JType)object, "copyOfObject");
        JVar o = m.param(8, (JType)object, "o");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given object.");
        m.javadoc().addParam(o).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code o} or {@code null} if {@code o} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional objectNotNull = m.body()._if(o.ne(JExpr._null()));
        JConditional isPrimitive = objectNotNull._then()._if((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)o, (String)"getClass"), (String)"isPrimitive"));
        isPrimitive._then()._return((JExpression)o);
        JConditional isArray = objectNotNull._then()._if((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)o, (String)"getClass"), (String)"isArray"));
        isArray._then()._return((JExpression)this.getCopyOfArrayInvocation(clazz).arg((JExpression)o));
        for (Class immutableType : IMMUTABLE_TYPES) {
            objectNotNull._then()._if(o._instanceof((JType)clazz.parent().getCodeModel().ref(immutableType)))._then()._return((JExpression)o);
        }
        for (Class cloneableType : CLONEABLE_TYPES) {
            JClass cloneable = clazz.parent().getCodeModel().ref(cloneableType);
            objectNotNull._then()._if(o._instanceof((JType)cloneable))._then()._return((JExpression)JExpr.invoke((JExpression)JExpr.cast((JType)cloneable, (JExpression)o), (String)"clone"));
        }
        JConditional instanceOfDOMElement = objectNotNull._then()._if(o._instanceof((JType)element));
        instanceOfDOMElement._then()._return((JExpression)JExpr.cast((JType)element, (JExpression)JExpr.invoke((JExpression)JExpr.cast((JType)element, (JExpression)o), (String)"cloneNode").arg(JExpr.TRUE)));
        JConditional instanceOfElement = objectNotNull._then()._if(o._instanceof((JType)jaxbElement));
        instanceOfElement._then()._return((JExpression)this.getCopyOfJaxbElementInvocation(clazz).arg((JExpression)JExpr.cast((JType)jaxbElement, (JExpression)o)));
        JTryBlock tryCloneMethod = objectNotNull._then()._try();
        tryCloneMethod.body()._return((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)o, (String)"getClass"), (String)"getMethod").arg("clone").arg((JExpression)JExpr.cast((JType)classArray, (JExpression)JExpr._null())), (String)"invoke").arg((JExpression)o).arg((JExpression)JExpr.cast((JType)objectArray, (JExpression)JExpr._null())));
        JExpression assertionErrorMsg = JExpr.lit((String)"Unexpected instance during copying object '").plus((JExpression)o).plus(JExpr.lit((String)"'."));
        JCatchBlock catchNoSuchMethod = tryCloneMethod._catch(noSuchMethod);
        JConditional instanceOfSerializable = catchNoSuchMethod.body()._if(o._instanceof((JType)serializable));
        instanceOfSerializable._then()._return((JExpression)this.getCopyOfSerializableInvocation(clazz).arg((JExpression)JExpr.cast((JType)serializable, (JExpression)o)));
        catchNoSuchMethod.body().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        catchNoSuchMethod.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchNoSuchMethod.param("e"))));
        JCatchBlock catchIllegalAccess = tryCloneMethod._catch(illegalAccess);
        catchIllegalAccess.body().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        catchIllegalAccess.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchIllegalAccess.param("e"))));
        JCatchBlock catchInvocationTarget = tryCloneMethod._catch(invocationTarget);
        catchInvocationTarget.body().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        catchInvocationTarget.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchInvocationTarget.param("e"))));
        JCatchBlock catchSecurityException = tryCloneMethod._catch(securityException);
        catchSecurityException.body().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        catchSecurityException.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchSecurityException.param("e"))));
        JCatchBlock catchIllegalArgument = tryCloneMethod._catch(illegalArgument);
        catchIllegalArgument.body().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        catchIllegalArgument.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchIllegalArgument.param("e"))));
        JCatchBlock catchInitializerError = tryCloneMethod._catch(initializerError);
        catchInitializerError.body().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        catchInitializerError.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchInitializerError.param("e"))));
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfElementInfoInvocation(FieldOutline fieldOutline, CElementInfo element) {
        JType elementType = element.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        JType[] signature = new JType[]{elementType};
        String methodName = element.hasClass() ? "copyOf" + element.shortName() : "copyOf" + this.getMethodNamePart(element.getContentType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION)) + "Element";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : fieldOutline.parent()._package().objectFactory().methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return fieldOutline.parent()._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : fieldOutline.parent().implClass.methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? fieldOutline.parent()._package().objectFactory().method(0x10 | mod, elementType, methodName) : fieldOutline.parent().implClass.method(0x10 | mod, elementType, methodName);
        JVar e = m.param(8, elementType, "e");
        m.javadoc().append((Object)("Creates and returns a deep copy of a given {@code " + elementType.binaryName() + "} instance."));
        m.javadoc().addParam(e).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code e} or {@code null} if {@code e} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional elementNotNull = m.body()._if(e.ne(JExpr._null()));
        JInvocation newElement = element.hasClass() ? JExpr._new((JType)elementType).arg(this.getCopyExpression(fieldOutline, (CTypeInfo)element.getContentType(), elementNotNull._then(), (JExpression)JExpr.cast((JType)element.getContentType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION), (JExpression)JExpr.invoke((JExpression)e, (String)"getValue")))) : JExpr._new((JType)elementType).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getName")).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getDeclaredType")).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getScope")).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getValue"));
        JVar copy = elementNotNull._then().decl(8, elementType, "copy", (JExpression)newElement);
        elementNotNull._then().add((JStatement)copy.invoke("setNil").arg((JExpression)e.invoke("isNil")));
        if (!element.hasClass()) {
            elementNotNull._then().add((JStatement)copy.invoke("setValue").arg(this.getCopyExpression(fieldOutline, (CTypeInfo)element.getContentType(), elementNotNull._then(), (JExpression)JExpr.cast((JType)element.getContentType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION), (JExpression)copy.invoke("getValue")))));
        }
        elementNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? fieldOutline.parent()._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfArrayInfoInvocation(FieldOutline fieldOutline, CArrayInfo array) {
        JType arrayType = array.getAdapterUse() != null ? fieldOutline.parent().parent().getModel().getTypeInfo((NType)array.getAdapterUse().customType).toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION) : array.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        JType itemType = array.getItemType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        JType[] signature = new JType[]{arrayType};
        String methodName = "copyOf" + fieldOutline.getPropertyInfo().getName(true);
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : fieldOutline.parent()._package().objectFactory().methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return fieldOutline.parent()._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : fieldOutline.parent().implClass.methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? fieldOutline.parent()._package().objectFactory().method(0x10 | mod, arrayType, methodName) : fieldOutline.parent().implClass.method(0x10 | mod, arrayType, methodName);
        JVar a = m.param(8, arrayType, "array");
        m.javadoc().append((Object)("Creates and returns a deep copy of a given {@code " + arrayType.binaryName() + "} instance."));
        m.javadoc().addParam(a).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code array} or {@code null} if {@code array} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional arrayNotNull = m.body()._if(a.ne(JExpr._null()));
        JVar copy = arrayNotNull._then().decl(arrayType, "copy", (JExpression)JExpr.newArray((JType)itemType, (JExpression)a.ref("length")));
        JForLoop forEachItem = arrayNotNull._then()._for();
        JVar i = forEachItem.init((JType)fieldOutline.parent().parent().getCodeModel().INT, "i", a.ref("length").minus(JExpr.lit((int)1)));
        forEachItem.test(i.gte(JExpr.lit((int)0)));
        forEachItem.update(i.decr());
        JExpression copyExpr = this.getCopyExpression(fieldOutline, (CTypeInfo)array.getItemType(), forEachItem.body(), (JExpression)a.component((JExpression)i));
        forEachItem.body().assign((JAssignmentTarget)copy.component((JExpression)i), copyExpr);
        arrayNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? fieldOutline.parent()._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JMethod getCopyOfPropertyMethod(FieldOutline field) {
        JExpression copyExpr;
        JConditional ifInstanceOf;
        JType javaType;
        JType contentType;
        String methodName = "copy" + field.getPropertyInfo().getName(true);
        for (JMethod m : field.parent().implClass.methods()) {
            if (!m.name().equals(methodName)) continue;
            return m;
        }
        JClass jaxbElement = field.parent().parent().getCodeModel().ref(JAXBElement.class);
        JClass assertionError = field.parent().parent().getCodeModel().ref(AssertionError.class);
        JMethod m = field.parent().implClass.method(this.getVisibilityModifier() | 0x10, field.getRawType(), methodName);
        JVar source = m.param(8, field.getRawType(), "source");
        m.javadoc().append((Object)("Creates and returns a deep copy of property {@code " + field.getPropertyInfo().getName(true) + "}."));
        m.javadoc().addParam(source).append((Object)"The source to copy from or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code source} or {@code null} if {@code source} is {@code null}.");
        m.body().directStatement("// " + this.getMessage("title", null));
        JConditional sourceNotNull = m.body()._if(source.ne(JExpr._null()));
        ArrayList<CClassInfo> referencedClassInfos = new ArrayList<CClassInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfos = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfosWithClass = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CTypeInfo> referencedTypeInfos = new ArrayList<CTypeInfo>(field.getPropertyInfo().ref().size());
        ArrayList<JClass> referencedClassTypes = new ArrayList<JClass>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedContentTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        for (CTypeInfo type : field.getPropertyInfo().ref()) {
            if (type instanceof CElementInfo) {
                CElementInfo e = (CElementInfo)type;
                if (e.hasClass()) {
                    referencedElementInfosWithClass.add(e);
                    continue;
                }
                contentType = e.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedContentTypes.contains(contentType)) continue;
                referencedContentTypes.add(contentType);
                referencedElementInfos.add(e);
                continue;
            }
            if (type instanceof CClassInfo) {
                CClassInfo c = (CClassInfo)type;
                JClass classType = c.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedClassTypes.contains(classType)) continue;
                referencedClassTypes.add(classType);
                referencedClassInfos.add(c);
                continue;
            }
            javaType = type.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            if (referencedTypes.contains(javaType)) continue;
            referencedTypes.add(javaType);
            referencedTypeInfos.add(type);
        }
        Collections.sort(referencedClassInfos, new CClassInfoComparator(field.parent().parent()));
        Collections.sort(referencedElementInfos, new CElementInfoComparator(field.parent().parent(), false));
        Collections.sort(referencedElementInfosWithClass, new CElementInfoComparator(field.parent().parent(), true));
        Collections.sort(referencedTypeInfos, new CTypeInfoComparator(field.parent().parent()));
        Collections.reverse(referencedClassInfos);
        Collections.reverse(referencedElementInfos);
        Collections.reverse(referencedElementInfosWithClass);
        Collections.reverse(referencedTypeInfos);
        if (!referencedElementInfos.isEmpty() || !referencedElementInfosWithClass.isEmpty()) {
            JExpression copyExpr2;
            JConditional ifInstanceOf2;
            JBlock elementBlock = sourceNotNull._then()._if(source._instanceof((JType)jaxbElement))._then();
            if (!referencedElementInfosWithClass.isEmpty()) {
                elementBlock.directStatement("// Referenced elements with classes.");
                for (CElementInfo elementInfo : referencedElementInfosWithClass) {
                    JType elementType;
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, (ifInstanceOf2 = elementBlock._if(source._instanceof(elementType = elementInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION))))._then(), (JExpression)JExpr.cast((JType)elementType, (JExpression)source));
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
                        continue;
                    }
                    ifInstanceOf2._then()._return(copyExpr2);
                }
            }
            if (!referencedElementInfos.isEmpty()) {
                elementBlock.directStatement("// Referenced elements without classes.");
                for (CElementInfo elementInfo : referencedElementInfos) {
                    contentType = elementInfo.getAdapterUse() != null ? field.parent().parent().getModel().getTypeInfo((NType)elementInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : elementInfo.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    ifInstanceOf2 = elementBlock._if(JExpr.invoke((JExpression)JExpr.cast((JType)jaxbElement, (JExpression)source), (String)"getValue")._instanceof(contentType));
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, ifInstanceOf2._then(), (JExpression)JExpr.cast((JType)jaxbElement, (JExpression)source));
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
                        continue;
                    }
                    ifInstanceOf2._then()._return(copyExpr2);
                }
            }
        }
        for (CClassInfo classInfo : referencedClassInfos) {
            javaType = classInfo.getAdapterUse() != null ? field.parent().parent().getModel().getTypeInfo((NType)classInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : classInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = sourceNotNull._then()._if(source._instanceof(javaType));
            copyExpr = this.getCopyExpression(field, (CTypeInfo)classInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)source));
            if (copyExpr == null) {
                this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
                continue;
            }
            ifInstanceOf._then()._return(copyExpr);
        }
        for (CTypeInfo typeInfo : referencedTypeInfos) {
            javaType = typeInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = sourceNotNull._then()._if(source._instanceof(javaType));
            copyExpr = this.getCopyExpression(field, typeInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)source));
            if (copyExpr == null) {
                this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
                continue;
            }
            ifInstanceOf._then()._return(copyExpr);
        }
        sourceNotNull._then().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        sourceNotNull._then()._throw((JExpression)JExpr._new((JClass)assertionError).arg(JExpr.lit((String)"Unexpected instance '").plus((JExpression)source).plus(JExpr.lit((String)("' for property '" + field.getPropertyInfo().getName(true) + "' of class '" + field.parent().implClass.binaryName() + "'.")))));
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return m;
    }

    private JMethod getCopyOfCollectionMethod(FieldOutline field) {
        JExpression copyExpr;
        JConditional ifInstanceOf;
        JClass javaType;
        JVar next;
        JVar it;
        JForLoop copyLoop;
        JVar copy;
        JConditional sourceNotEmpty;
        String methodName = "copy" + field.getPropertyInfo().getName(true);
        for (JMethod m : field.parent().implClass.methods()) {
            if (!m.name().equals(methodName)) continue;
            return m;
        }
        JClass object = field.parent().parent().getCodeModel().ref(Object.class);
        JClass array = field.parent().parent().getCodeModel().ref(Array.class);
        JClass jaxbElement = field.parent().parent().getCodeModel().ref(JAXBElement.class);
        JClass nullPointerException = field.parent().parent().getCodeModel().ref(NullPointerException.class);
        JClass assertionError = field.parent().parent().getCodeModel().ref(AssertionError.class);
        JMethod m = field.parent().implClass.method(field.getRawType().isArray() ? this.getVisibilityModifier() : this.getVisibilityModifier() | 0x10, Void.TYPE, methodName);
        JVar source = m.param(8, field.getRawType(), "source");
        JVar target = field.getRawType().isArray() ? null : m.param(8, field.getRawType(), "target");
        m.javadoc().append((Object)("Copies all values of property {@code " + field.getPropertyInfo().getName(true) + "} deeply."));
        m.javadoc().addParam(source).append((Object)"The source to copy from.");
        if (!field.getRawType().isArray()) {
            m.javadoc().addParam(target).append((Object)"The target to copy {@code source} to.");
            m.javadoc().addThrows(nullPointerException).append((Object)"if {@code source} or {@code target} is {@code null}.");
        } else {
            m.javadoc().addThrows(nullPointerException).append((Object)"if {@code source} is {@code null}.");
        }
        m.body().directStatement("// " + this.getMessage("title", null));
        ArrayList<CClassInfo> referencedClassInfos = new ArrayList<CClassInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfos = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfosWithClass = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CTypeInfo> referencedTypeInfos = new ArrayList<CTypeInfo>(field.getPropertyInfo().ref().size());
        ArrayList<JClass> referencedClassTypes = new ArrayList<JClass>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedContentTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        for (CTypeInfo type : field.getPropertyInfo().ref()) {
            if (type instanceof CElementInfo) {
                CElementInfo e = (CElementInfo)type;
                if (e.hasClass()) {
                    referencedElementInfosWithClass.add(e);
                    continue;
                }
                JType contentType = e.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedContentTypes.contains(contentType)) continue;
                referencedContentTypes.add(contentType);
                referencedElementInfos.add(e);
                continue;
            }
            if (type instanceof CClassInfo) {
                CClassInfo c = (CClassInfo)type;
                JClass classType = c.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedClassTypes.contains(classType)) continue;
                referencedClassTypes.add(classType);
                referencedClassInfos.add(c);
                continue;
            }
            JType javaType2 = type.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            if (referencedTypes.contains(javaType2)) continue;
            referencedTypes.add(javaType2);
            referencedTypeInfos.add(type);
        }
        Collections.sort(referencedClassInfos, new CClassInfoComparator(field.parent().parent()));
        Collections.sort(referencedElementInfos, new CElementInfoComparator(field.parent().parent(), false));
        Collections.sort(referencedElementInfosWithClass, new CElementInfoComparator(field.parent().parent(), true));
        Collections.sort(referencedTypeInfos, new CTypeInfoComparator(field.parent().parent()));
        Collections.reverse(referencedClassInfos);
        Collections.reverse(referencedElementInfos);
        Collections.reverse(referencedElementInfosWithClass);
        Collections.reverse(referencedTypeInfos);
        if (field.getRawType().isArray()) {
            sourceNotEmpty = m.body()._if(source.ne(JExpr._null()).cand(source.ref("length").gt(JExpr.lit((int)0))));
            copy = sourceNotEmpty._then().decl(8, source.type(), "copy", (JExpression)JExpr.cast((JType)source.type(), (JExpression)array.staticInvoke("newInstance").arg((JExpression)source.invoke("getClass").invoke("getComponentType")).arg((JExpression)source.ref("length"))));
            copyLoop = sourceNotEmpty._then()._for();
            it = copyLoop.init((JType)field.parent().parent().getCodeModel().INT, "i", source.ref("length").minus(JExpr.lit((int)1)));
            copyLoop.test(it.gte(JExpr.lit((int)0)));
            copyLoop.update(it.decr());
            next = copyLoop.body().decl(8, (JType)object, "next", (JExpression)source.component((JExpression)it));
        } else {
            sourceNotEmpty = m.body()._if(JExpr.invoke((JExpression)source, (String)"isEmpty").not());
            copyLoop = sourceNotEmpty._then()._for();
            it = copyLoop.init((JType)field.parent().parent().getCodeModel().ref(Iterator.class), "it", (JExpression)source.invoke("iterator"));
            copyLoop.test((JExpression)JExpr.invoke((JExpression)it, (String)"hasNext"));
            next = copyLoop.body().decl(8, (JType)object, "next", (JExpression)JExpr.invoke((JExpression)it, (String)"next"));
            copy = null;
        }
        if (!referencedElementInfos.isEmpty() || !referencedElementInfosWithClass.isEmpty()) {
            JExpression copyExpr2;
            JConditional ifInstanceOf2;
            JBlock copyBlock = copyLoop.body()._if(next._instanceof((JType)jaxbElement))._then();
            if (!referencedElementInfosWithClass.isEmpty()) {
                copyBlock.directStatement("// Referenced elements with classes.");
                for (CElementInfo elementInfo : referencedElementInfosWithClass) {
                    JType elementType;
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, (ifInstanceOf2 = copyBlock._if(next._instanceof(elementType = elementInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION))))._then(), (JExpression)JExpr.cast((JType)elementType, (JExpression)next));
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
                        continue;
                    }
                    if (field.getRawType().isArray()) {
                        ifInstanceOf2._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr2);
                    } else {
                        ifInstanceOf2._then().invoke((JExpression)target, "add").arg(copyExpr2);
                    }
                    ifInstanceOf2._then()._continue();
                }
            }
            if (!referencedElementInfos.isEmpty()) {
                copyBlock.directStatement("// Referenced elements without classes.");
                for (CElementInfo elementInfo : referencedElementInfos) {
                    JType contentType = elementInfo.getAdapterUse() != null ? field.parent().parent().getModel().getTypeInfo((NType)elementInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : elementInfo.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    ifInstanceOf2 = copyBlock._if(JExpr.invoke((JExpression)JExpr.cast((JType)jaxbElement, (JExpression)next), (String)"getValue")._instanceof(contentType));
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, ifInstanceOf2._then(), (JExpression)JExpr.cast((JType)jaxbElement, (JExpression)next));
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
                    } else if (field.getRawType().isArray()) {
                        ifInstanceOf2._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr2);
                    } else {
                        ifInstanceOf2._then().invoke((JExpression)target, "add").arg(copyExpr2);
                    }
                    ifInstanceOf2._then()._continue();
                }
            }
        }
        for (CClassInfo classInfo : referencedClassInfos) {
            javaType = classInfo.getAdapterUse() != null ? field.parent().parent().getModel().getTypeInfo((NType)classInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : classInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = copyLoop.body()._if(next._instanceof((JType)javaType));
            copyExpr = this.getCopyExpression(field, (CTypeInfo)classInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)next));
            if (copyExpr == null) {
                this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
            } else if (field.getRawType().isArray()) {
                ifInstanceOf._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr);
            } else {
                ifInstanceOf._then().invoke((JExpression)target, "add").arg(copyExpr);
            }
            ifInstanceOf._then()._continue();
        }
        for (CTypeInfo typeInfo : referencedTypeInfos) {
            javaType = typeInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = copyLoop.body()._if(next._instanceof((JType)javaType));
            copyExpr = this.getCopyExpression(field, typeInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)next));
            if (copyExpr == null) {
                this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
            } else if (field.getRawType().isArray()) {
                ifInstanceOf._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr);
            } else {
                ifInstanceOf._then().invoke((JExpression)target, "add").arg(copyExpr);
            }
            ifInstanceOf._then()._continue();
        }
        copyLoop.body().directStatement("// Please report this at " + this.getMessage("bugtrackerUrl", null));
        copyLoop.body()._throw((JExpression)JExpr._new((JClass)assertionError).arg(JExpr.lit((String)"Unexpected instance '").plus((JExpression)next).plus(JExpr.lit((String)("' for property '" + field.getPropertyInfo().getName(true) + "' of class '" + field.parent().implClass.binaryName() + "'.")))));
        if (field.getRawType().isArray()) {
            sourceNotEmpty._then().add((JStatement)JExpr.invoke((String)("set" + field.getPropertyInfo().getName(true))).arg((JExpression)copy));
        }
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return m;
    }

    private JExpression getCopyExpression(FieldOutline fieldOutline, CTypeInfo type, JBlock block, JExpression source) {
        JExpression expr = null;
        if (type instanceof CBuiltinLeafInfo) {
            expr = this.getBuiltinCopyExpression(fieldOutline, (CBuiltinLeafInfo)type, block, source);
        } else if (type instanceof CWildcardTypeInfo) {
            expr = this.getWildcardCopyExpression(fieldOutline, (CWildcardTypeInfo)type, block, source);
        } else if (type instanceof CClassInfo) {
            expr = this.getClassInfoCopyExpression(fieldOutline, (CClassInfo)type, block, source);
        } else if (type instanceof CEnumLeafInfo) {
            expr = this.getEnumLeafInfoCopyExpression(fieldOutline, (CEnumLeafInfo)type, block, source);
        } else if (type instanceof CArrayInfo) {
            expr = this.getArrayCopyExpression(fieldOutline, (CArrayInfo)type, block, source);
        } else if (type instanceof CElementInfo) {
            expr = this.getElementCopyExpression(fieldOutline, (CElementInfo)type, block, source);
        } else if (type instanceof CNonElement) {
            expr = this.getNonElementCopyExpression(fieldOutline, (CNonElement)type, block, source);
        }
        if (expr != null) {
            this.expressionCount = this.expressionCount.add(BigInteger.ONE);
        }
        return expr;
    }

    private JExpression getBuiltinCopyExpression(FieldOutline fieldOutline, CBuiltinLeafInfo type, JBlock block, JExpression source) {
        JInvocation expr = null;
        block.directStatement("// CBuiltinLeafInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        if (type == CBuiltinLeafInfo.ANYTYPE) {
            expr = this.getCopyOfObjectInvocation(fieldOutline.parent()).arg(source);
        } else if (type == CBuiltinLeafInfo.BASE64_BYTE_ARRAY) {
            JClass byteArray = fieldOutline.parent().parent().getCodeModel().ref(byte[].class);
            expr = this.getCopyOfPrimitiveArrayExpression(fieldOutline.parent(), byteArray, source);
        } else if (type == CBuiltinLeafInfo.BIG_DECIMAL || type == CBuiltinLeafInfo.BIG_INTEGER || type == CBuiltinLeafInfo.STRING || type == CBuiltinLeafInfo.BOOLEAN || type == CBuiltinLeafInfo.INT || type == CBuiltinLeafInfo.LONG || type == CBuiltinLeafInfo.BYTE || type == CBuiltinLeafInfo.SHORT || type == CBuiltinLeafInfo.FLOAT || type == CBuiltinLeafInfo.DOUBLE) {
            expr = source;
        } else if (type == CBuiltinLeafInfo.QNAME) {
            expr = source;
        } else if (type == CBuiltinLeafInfo.CALENDAR) {
            JClass xmlCal = fieldOutline.parent().parent().getCodeModel().ref(XMLGregorianCalendar.class);
            expr = JOp.cond((JExpression)source.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr.cast((JType)xmlCal, (JExpression)source.invoke("clone")));
        } else if (type == CBuiltinLeafInfo.DURATION) {
            expr = source;
        } else if (type == CBuiltinLeafInfo.DATA_HANDLER || type == CBuiltinLeafInfo.IMAGE || type == CBuiltinLeafInfo.XML_SOURCE) {
            this.log(Level.WARNING, "cannotCopyType", new Object[]{type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).fullName(), fieldOutline.getPropertyInfo().getName(true), fieldOutline.parent().implClass.fullName()});
            expr = source;
        }
        return expr;
    }

    private JExpression getWildcardCopyExpression(FieldOutline fieldOutline, CWildcardTypeInfo type, JBlock block, JExpression source) {
        block.directStatement("// CWildcardTypeInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        return JOp.cond((JExpression)source.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr.cast((JType)fieldOutline.parent().parent().getCodeModel().ref(Element.class), (JExpression)source.invoke("cloneNode").arg(JExpr.TRUE)));
    }

    private JExpression getClassInfoCopyExpression(FieldOutline fieldOutline, CClassInfo type, JBlock block, JExpression source) {
        block.directStatement("// CClassInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        return JOp.cond((JExpression)source.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)source.invoke("clone"));
    }

    private JExpression getNonElementCopyExpression(FieldOutline fieldOutline, CNonElement type, JBlock block, JExpression source) {
        block.directStatement("// CNonElement: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        return null;
    }

    private JExpression getArrayCopyExpression(FieldOutline fieldOutline, CArrayInfo type, JBlock block, JExpression source) {
        block.directStatement("// CArrayInfo: " + type.fullName());
        return this.getCopyOfArrayInfoInvocation(fieldOutline, type).arg(source);
    }

    private JExpression getElementCopyExpression(FieldOutline fieldOutline, CElementInfo type, JBlock block, JExpression source) {
        block.directStatement("// CElementInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        return this.getCopyOfElementInfoInvocation(fieldOutline, type).arg(source);
    }

    private JExpression getEnumLeafInfoCopyExpression(FieldOutline fieldOutline, CEnumLeafInfo type, JBlock block, JExpression source) {
        block.directStatement("// CEnumLeafInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        return source;
    }

    private JMethod generateStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.constructor(1);
        ctor.body().directStatement(" // " + this.getMessage("title", null));
        ctor.body().invoke("super");
        ctor.javadoc().add((Object)("Creates a new {@code " + clazz.implClass.name() + "} instance."));
        this.constructorCount = this.constructorCount.add(BigInteger.ONE);
        return ctor;
    }

    private JMethod generateCopyConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.constructor(1);
        JVar o = ctor.param(8, (JType)clazz.implClass, "o");
        ctor.javadoc().add((Object)("Creates a new {@code " + clazz.implClass.name() + "} instance by deeply copying a given instance."));
        ctor.javadoc().addParam(o).add((Object)"The instance to copy or {@code null}.");
        ctor.body().directStatement(" // " + this.getMessage("title", null));
        if (clazz.getSuperClass() != null) {
            ctor.body().invoke("super").arg((JExpression)o);
        } else {
            ctor.body().invoke("super");
        }
        boolean hasFields = false;
        if (!clazz.implClass.fields().isEmpty()) {
            JBlock paramNotNullBlock = new JBlock(true, true);
            for (FieldOutline field : clazz.getDeclaredFields()) {
                hasFields = true;
                this.generateCopyOfProperty(field, o, paramNotNullBlock);
            }
            for (JFieldVar field : clazz.implClass.fields().values()) {
                if ((field.mods().getValue() & 0x10) == 16) continue;
                hasFields = true;
                FieldOutline fieldOutline = this.getFieldOutline(clazz, field.name());
                if (fieldOutline != null) continue;
                if (field.type().isPrimitive()) {
                    paramNotNullBlock.assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)o.ref((JVar)field));
                    this.log(Level.WARNING, "fieldWithoutProperties", new Object[]{field.name(), clazz.implClass.name()});
                    continue;
                }
                if (field.name().equals("otherAttributes") && clazz.target.declaresAttributeWildcard()) {
                    paramNotNullBlock.add((JStatement)JExpr.refthis((String)field.name()).invoke("putAll").arg((JExpression)o.ref((JVar)field)));
                    continue;
                }
                paramNotNullBlock.assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)JExpr.cast((JType)field.type(), (JExpression)this.getCopyOfObjectInvocation(clazz).arg((JExpression)o.ref((JVar)field))));
                this.log(Level.WARNING, "fieldWithoutProperties", new Object[]{field.name(), clazz.implClass.name()});
            }
            if (hasFields) {
                ctor.body()._if(o.ne(JExpr._null()))._then().add((JStatement)paramNotNullBlock);
            }
        }
        this.constructorCount = this.constructorCount.add(BigInteger.ONE);
        return ctor;
    }

    private JMethod generateCloneMethod(ClassOutline clazz) {
        JMethod cloneMethod = null;
        if (clazz.implClass.isAbstract()) {
            cloneMethod = clazz.implClass.method(33, (JType)clazz.implClass, "clone");
        } else {
            cloneMethod = clazz.implClass.method(1, (JType)clazz.implClass, "clone");
            cloneMethod.body().directStatement(" // " + this.getMessage("title", null));
            cloneMethod.body()._return((JExpression)JExpr._new((JClass)clazz.implClass).arg(JExpr._this()));
        }
        cloneMethod.annotate(Override.class);
        clazz.implClass._implements(clazz.parent().getCodeModel().ref(Cloneable.class));
        cloneMethod.javadoc().append((Object)"Creates and returns a deep copy of this object.\n");
        cloneMethod.javadoc().addReturn().append((Object)"A deep copy of this object.");
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return cloneMethod;
    }

    private void generateCopyOfProperty(FieldOutline field, JVar o, JBlock block) {
        JMethod getter = this.getPropertyGetter(field);
        if (getter != null) {
            if (field.getPropertyInfo().isCollection()) {
                if (field.getRawType().isArray()) {
                    block.directStatement("// '" + field.getPropertyInfo().getName(true) + "' array.");
                    block.add((JStatement)JExpr.invoke((JMethod)this.getCopyOfCollectionMethod(field)).arg((JExpression)JExpr.invoke((JExpression)o, (JMethod)getter)));
                } else {
                    block.directStatement("// '" + field.getPropertyInfo().getName(true) + "' collection.");
                    block.add((JStatement)JExpr.invoke((JMethod)this.getCopyOfCollectionMethod(field)).arg((JExpression)JExpr.invoke((JExpression)o, (JMethod)getter)).arg((JExpression)JExpr.invoke((JMethod)getter)));
                }
            } else {
                JInvocation copyExpr;
                if (field.getPropertyInfo().ref().size() != 1) {
                    block.directStatement("// '" + field.getPropertyInfo().getName(true) + "' property.");
                    copyExpr = JExpr.invoke((JMethod)this.getCopyOfPropertyMethod(field)).arg((JExpression)o.invoke(getter));
                } else {
                    CTypeInfo typeInfo = field.getPropertyInfo().getAdapter() != null ? field.parent().parent().getModel().getTypeInfo((NType)field.getPropertyInfo().getAdapter().customType) : (CTypeInfo)field.getPropertyInfo().ref().iterator().next();
                    JType javaType = typeInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    copyExpr = this.getCopyExpression(field, typeInfo, block, (JExpression)JExpr.cast((JType)javaType, (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter)));
                }
                if (copyExpr == null) {
                    this.log(Level.SEVERE, this.getMessage("cannotCopyProperty", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}), null);
                } else {
                    block.assign((JAssignmentTarget)JExpr.refthis((String)field.getPropertyInfo().getName(false)), (JExpression)copyExpr);
                }
            }
        } else {
            throw new AssertionError((Object)this.getMessage("getterNotFound", new Object[]{field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()}));
        }
    }

    private String getMethodNamePart(JType type) {
        String methodName = type.name();
        if (type.isArray()) {
            methodName = methodName.replace("[]", "s");
        }
        methodName = methodName.replace(".", "");
        char[] c = methodName.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        methodName = String.valueOf(c);
        return methodName;
    }

    private String getMessage(String key, Object args) {
        ResourceBundle bundle = ResourceBundle.getBundle("net/sourceforge/ccxjc/PluginImpl");
        return new MessageFormat(bundle.getString(key)).format(args);
    }

    private void log(Level level, String key, Object args) {
        StringBuffer b = new StringBuffer().append("[").append(MESSAGE_PREFIX).append("] [").append(level.getLocalizedName()).append("] ").append(this.getMessage(key, args));
        int logLevel = Level.WARNING.intValue();
        if (this.options != null && !this.options.quiet) {
            if (this.options.verbose) {
                logLevel = Level.INFO.intValue();
            }
            if (this.options.debugMode) {
                logLevel = Level.ALL.intValue();
            }
        }
        if (level.intValue() >= logLevel) {
            if (level.intValue() <= Level.INFO.intValue()) {
                System.out.println(b.toString());
            } else {
                System.err.println(b.toString());
            }
        }
    }
}

