/*
 * Decompiled with CFR 0.152.
 */
package net.somta.extra.cache.redis.serialize;

import net.somta.core.helper.JsonSerializeHelper;
import net.somta.extra.cache.redis.serialize.InterfaceSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializable
implements InterfaceSerializable {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializable.class);

    @Override
    public <T> String serialize(T value) {
        try {
            return JsonSerializeHelper.serialize(value);
        }
        catch (Exception e) {
            logger.error("json serialize error", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T deserialize(String data, Class<T> clazz) {
        try {
            return (T)JsonSerializeHelper.deserialize((String)data, clazz);
        }
        catch (Exception e) {
            logger.error("json deserialize error", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T deserialize(String data, Class<T> clazz, Class<?> elementClasses) {
        try {
            return (T)JsonSerializeHelper.deserialize((String)data, clazz, elementClasses);
        }
        catch (Exception e) {
            logger.error("json deserialize error", (Throwable)e);
            return null;
        }
    }
}

