/*
 * Decompiled with CFR 0.152.
 */
package net.somta.extra.cache.redis.client;

import java.util.ArrayList;
import java.util.Arrays;
import net.somta.core.base.IBaseError;
import net.somta.extra.cache.redis.client.AbstractRedisClient;
import net.somta.extra.cache.redis.exception.RedisException;
import net.somta.extra.cache.redis.model.RedisConfigItem;
import net.somta.extra.cache.redis.model.RedisErrorEnum;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.redisson.config.ReadMode;
import org.redisson.config.SentinelServersConfig;

public class SentinelRedisClient
extends AbstractRedisClient {
    @Override
    protected void initClientConfig(Config redisConfig, RedisConfigItem redisConfigItem) {
        String sentinelMaster = redisConfigItem.getSentinelMaster();
        if (StringUtils.isEmpty((CharSequence)sentinelMaster)) {
            throw new RedisException((IBaseError)RedisErrorEnum.REDIS_SENTINEL_MASTER_NAME_ERROR, new Object[0]);
        }
        String[] sentinelNodes = redisConfigItem.getAddress();
        int timeout = redisConfigItem.getTimeout();
        int poolSize = redisConfigItem.getPoolSize();
        int poolMinIdleSize = redisConfigItem.getPoolMinIdle();
        String password = redisConfigItem.getPassword();
        ArrayList sentinelNodeList = new ArrayList(sentinelNodes.length);
        Arrays.stream(sentinelNodes).forEach(address -> sentinelNodeList.add(address.startsWith("redis://") ? address.trim() : "redis://" + address.trim()));
        SentinelServersConfig sentinelServersConfig = ((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)redisConfig.useSentinelServers().addSentinelAddress(sentinelNodeList.toArray(new String[0])).setClientName(redisConfigItem.getClientName())).setMasterName(sentinelMaster).setReadMode(ReadMode.SLAVE)).setTimeout(timeout)).setMasterConnectionPoolSize(poolSize)).setMasterConnectionMinimumIdleSize(poolMinIdleSize)).setSlaveConnectionPoolSize(poolSize)).setSlaveConnectionMinimumIdleSize(poolMinIdleSize)).setDatabase(redisConfigItem.getDatabase().intValue());
        if (StringUtils.isNotBlank((CharSequence)password)) {
            sentinelServersConfig.setPassword(password);
        }
    }
}

