/*
 * Decompiled with CFR 0.152.
 */
package net.somta.extra.cache.redis.client;

import java.util.ArrayList;
import java.util.Arrays;
import net.somta.extra.cache.redis.client.AbstractRedisClient;
import net.somta.extra.cache.redis.model.RedisConfigItem;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;

public class ClusterRedisClient
extends AbstractRedisClient {
    @Override
    protected void initClientConfig(Config redisConfig, RedisConfigItem redisConfigItem) {
        String[] clusterNodes = redisConfigItem.getAddress();
        int timeout = redisConfigItem.getTimeout();
        int retryAttempts = redisConfigItem.getRetryAttempts();
        int retryInterval = redisConfigItem.getRetryInterval();
        int scanInterval = redisConfigItem.getScanInterval();
        int connectTimeout = redisConfigItem.getConnectTimeout();
        int poolMinIdleSize = redisConfigItem.getPoolMinIdle();
        int masterConnectionPoolSize = redisConfigItem.getMasterConnectionPoolSize();
        int slaveConnectionPoolSize = redisConfigItem.getSlaveConnectionPoolSize();
        String password = redisConfigItem.getPassword();
        ArrayList clusterNodeList = new ArrayList(clusterNodes.length);
        Arrays.stream(clusterNodes).forEach(address -> clusterNodeList.add(address.startsWith("redis://") ? address.trim() : "redis://" + address.trim()));
        ClusterServersConfig clusterServersConfig = (ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)redisConfig.useClusterServers().addNodeAddress(clusterNodeList.toArray(new String[0])).setClientName(redisConfigItem.getClientName())).setScanInterval(scanInterval).setConnectTimeout(connectTimeout)).setRetryAttempts(retryAttempts)).setRetryInterval(retryInterval)).setMasterConnectionPoolSize(masterConnectionPoolSize)).setMasterConnectionMinimumIdleSize(poolMinIdleSize)).setSlaveConnectionPoolSize(slaveConnectionPoolSize)).setSlaveConnectionMinimumIdleSize(poolMinIdleSize)).setTimeout(timeout);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            clusterServersConfig.setPassword(password);
        }
    }
}

