/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.setup.mockpkg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.solarnetwork.node.service.PlatformPackageService;
import net.solarnetwork.node.service.support.BasePlatformPackageService;
import net.solarnetwork.node.service.support.BasicPlatformPackage;
import net.solarnetwork.node.service.support.BasicPlatformPackageResult;
import net.solarnetwork.service.ProgressListener;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.util.StringUtils;

public class MockPlatformPackageService
extends BasePlatformPackageService
implements ServiceLifecycleObserver {
    private final ConcurrentNavigableMap<String, PlatformPackageService.PlatformPackage> available = new ConcurrentSkipListMap<String, PlatformPackageService.PlatformPackage>();
    private final ConcurrentNavigableMap<String, PlatformPackageService.PlatformPackage> installed = new ConcurrentSkipListMap<String, PlatformPackageService.PlatformPackage>();
    private final ConcurrentNavigableMap<String, PlatformPackageService.PlatformPackage> upgradable = new ConcurrentSkipListMap<String, PlatformPackageService.PlatformPackage>();
    private static final Pattern DEB_FILENAME_PATTERN = Pattern.compile("^(.*)_(.*)_(.*)\\.deb$");

    public void serviceDidStartup() {
        this.performTask(() -> {
            this.loadPackages();
            return null;
        });
    }

    private synchronized void loadPackages() {
        this.available.clear();
        this.installed.clear();
        this.upgradable.clear();
        this.parsePackages("solarpkg-list-available-11.csv", this.available);
        this.parsePackages("solarpkg-list-installed-11.csv", this.installed);
        this.parsePackages("solarpkg-list-upgradable-11.csv", this.upgradable);
        this.log.info("Initialized {} installed and {} available and {} upgradable packages", new Object[]{this.installed.size(), this.available.size(), this.upgradable.size()});
    }

    private void parsePackages(String resource, Map<String, PlatformPackageService.PlatformPackage> dest) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(resource), StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                MockPlatformPackageService.parsePackage(line, dest);
            }
        }
        catch (IOException e) {
            this.log.error("I/O error parsing resource [" + resource + "]: " + e.toString());
        }
    }

    private static PlatformPackageService.PlatformPackage parsePackage(String line, Map<String, PlatformPackageService.PlatformPackage> dest) {
        BasicPlatformPackage pkg;
        String[] cols = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)line);
        if (cols != null && cols.length > 2 && (pkg = new BasicPlatformPackage(cols[0], cols[1], StringUtils.parseBoolean((String)cols[2]))) != null) {
            dest.put(pkg.getName(), (PlatformPackageService.PlatformPackage)pkg);
        }
        return null;
    }

    public void serviceDidShutdown() {
    }

    public boolean handlesPackage(String archiveFileName) {
        return archiveFileName != null && archiveFileName.endsWith(".deb");
    }

    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> installPackage(final Path archive, Path baseDirectory, final ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                MockPlatformPackageService.this.log.info("Installing package archive {}", (Object)archive);
                Matcher m = DEB_FILENAME_PATTERN.matcher(archive.getFileName().toString());
                if (m.matches()) {
                    String name = m.group(1);
                    String version = m.group(2);
                    BasicPlatformPackage pkg = new BasicPlatformPackage(name, version, true);
                    MockPlatformPackageService.this.installed.put(name, (PlatformPackageService.PlatformPackage)pkg);
                    MockPlatformPackageService.this.available.remove(name);
                }
                progressListener.progressChanged(context, 1.0);
                return new BasicPlatformPackageResult(true, null, null, Collections.emptyList(), context);
            }
        };
        return this.performPackageResultTask(task, context);
    }

    public Future<Iterable<PlatformPackageService.PlatformPackage>> listNamedPackages(String nameFilter, Boolean installedFilter) {
        Pattern filter = this.globPattern(nameFilter);
        return this.performTask(() -> {
            if (Boolean.TRUE.equals(installedFilter)) {
                if (filter == null) {
                    return this.installed.values();
                }
                return this.installed.values().stream().filter(pkg -> filter.matcher(pkg.getName()).matches()).collect(Collectors.toList());
            }
            if (Boolean.FALSE.equals(installedFilter)) {
                if (filter == null) {
                    return this.available.values();
                }
                return this.available.values().stream().filter(pkg -> filter.matcher(pkg.getName()).matches()).collect(Collectors.toList());
            }
            ArrayList<PlatformPackageService.PlatformPackage> result = new ArrayList<PlatformPackageService.PlatformPackage>();
            for (PlatformPackageService.PlatformPackage pkg2 : this.installed.values()) {
                if (filter != null && !filter.matcher(pkg2.getName()).matches()) continue;
                result.add(pkg2);
            }
            for (PlatformPackageService.PlatformPackage pkg2 : this.available.values()) {
                if (filter != null && !filter.matcher(pkg2.getName()).matches()) continue;
                result.add(pkg2);
            }
            Collections.sort(result, (l, r) -> {
                String nl = l.getName();
                String nr = r.getName();
                return nl.compareToIgnoreCase(nr);
            });
            return result;
        });
    }

    public Future<Iterable<PlatformPackageService.PlatformPackage>> listUpgradableNamedPackages() {
        return this.performTask(() -> this.upgradable.values());
    }

    private Pattern globPattern(String nameFilter) {
        if (nameFilter == null || nameFilter.trim().isEmpty()) {
            return null;
        }
        String[] parts = nameFilter.split("\\*");
        if (parts.length == 1) {
            return Pattern.compile(Pattern.quote(nameFilter), 2);
        }
        StringBuilder buf = new StringBuilder();
        for (String part : parts) {
            buf.append(Pattern.quote(part));
            buf.append(".*");
        }
        return Pattern.compile(buf.toString(), 2);
    }

    public Future<Boolean> refreshNamedPackages() {
        return this.performTask(() -> {
            this.loadPackages();
            return true;
        });
    }

    public Future<Boolean> cleanup() {
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> installNamedPackage(final String name, String version, Path baseDirectory, final ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                MockPlatformPackageService.this.log.info("Installing named package {}", (Object)name);
                if (MockPlatformPackageService.this.available.containsKey(name)) {
                    MockPlatformPackageService.this.installed.put(name, (PlatformPackageService.PlatformPackage)MockPlatformPackageService.this.available.remove(name));
                } else if (MockPlatformPackageService.this.upgradable.containsKey(name)) {
                    MockPlatformPackageService.this.installed.put(name, (PlatformPackageService.PlatformPackage)MockPlatformPackageService.this.upgradable.remove(name));
                }
                progressListener.progressChanged(context, 1.0);
                return new BasicPlatformPackageResult(true, null, null, Collections.emptyList(), context);
            }
        };
        return this.performPackageResultTask(task, context);
    }

    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> removeNamedPackage(final String name, final ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                MockPlatformPackageService.this.log.info("Installing named package {}", (Object)name);
                if (MockPlatformPackageService.this.upgradable.containsKey(name)) {
                    MockPlatformPackageService.this.available.put(name, (PlatformPackageService.PlatformPackage)MockPlatformPackageService.this.upgradable.remove(name));
                    MockPlatformPackageService.this.installed.remove(name);
                } else if (MockPlatformPackageService.this.installed.containsKey(name)) {
                    MockPlatformPackageService.this.available.put(name, (PlatformPackageService.PlatformPackage)MockPlatformPackageService.this.installed.remove(name));
                }
                progressListener.progressChanged(context, 1.0);
                return new BasicPlatformPackageResult(true, null, null, Collections.emptyList(), context);
            }
        };
        return this.performPackageResultTask(task, context);
    }

    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> upgradeNamedPackages(final ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                MockPlatformPackageService.this.log.info("Upgrading named packages");
                int count = MockPlatformPackageService.this.upgradable.size();
                int i = 0;
                for (Map.Entry e : MockPlatformPackageService.this.upgradable.entrySet()) {
                    MockPlatformPackageService.this.installed.put((String)e.getKey(), (PlatformPackageService.PlatformPackage)e.getValue());
                    progressListener.progressChanged(context, (double)(++i) / (double)count);
                }
                MockPlatformPackageService.this.upgradable.clear();
                return new BasicPlatformPackageResult(true, null, null, Collections.emptyList(), context);
            }
        };
        return this.performPackageResultTask(task, context);
    }
}

