/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao.jdbc.postgres;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashSet;
import javax.sql.DataSource;
import net.solarnetwork.node.dao.jdbc.DatabaseSystemService;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgresDatabaseSystemService
implements DatabaseSystemService {
    private static final String SQL_TABLE_DISK_SIZE = "SELECT pg_total_relation_size(?)";
    private static final String SQL_TABLE_VACUUM = "VACUUM %s.%s";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Collection<DataSource> dataSources;

    public PostgresDatabaseSystemService(Collection<DataSource> dataSources) {
        this.dataSources = (Collection)ObjectUtils.requireNonNullArgument(dataSources, (String)"dataSources");
    }

    public File[] getFileSystemRoots() {
        return new File[0];
    }

    public long tableFileSystemSize(String schemaName, String tableName) {
        HashSet urls = new HashSet();
        long result = 0L;
        for (DataSource dataSource : this.dataSources) {
            JdbcTemplate jdbcOps = new JdbcTemplate(dataSource);
            try {
                result += ((Long)jdbcOps.execute(conn -> {
                    String url = conn.getMetaData().getURL();
                    if (urls.contains(url)) {
                        return 0L;
                    }
                    urls.add(url);
                    try (PreparedStatement stmt = conn.prepareStatement(SQL_TABLE_DISK_SIZE);){
                        stmt.setString(1, String.format("%s.%s", schemaName, tableName));
                        try (ResultSet rs = stmt.executeQuery();){
                            if (rs.next()) {
                                long size = rs.getLong(1);
                                this.log.debug("Found table {}.{} has disk size {}", new Object[]{schemaName, tableName, size});
                                Long l = size;
                                return l;
                            }
                        }
                    }
                    return 0L;
                })).longValue();
            }
            catch (DataAccessException e) {
                this.log.debug("Ignoring DB exception calculating disk size of database table {}.{}: {}", new Object[]{schemaName, tableName, e.toString()});
            }
        }
        return result;
    }

    public void vacuumTable(String schemaName, String tableName) {
        HashSet urls = new HashSet();
        for (DataSource dataSource : this.dataSources) {
            JdbcTemplate jdbcOps = new JdbcTemplate(dataSource);
            try {
                jdbcOps.execute(conn -> {
                    String url = conn.getMetaData().getURL();
                    if (urls.contains(url)) {
                        return null;
                    }
                    urls.add(url);
                    try (PreparedStatement stmt = conn.prepareStatement(String.format(SQL_TABLE_VACUUM, schemaName, tableName));){
                        stmt.execute();
                        this.log.debug("Vacuumed table {}.{}", (Object)schemaName, (Object)tableName);
                    }
                    return null;
                });
            }
            catch (DataAccessException e) {
                this.log.warn("Ignoring DB exception vacuuming database table {}.{}: {}", new Object[]{schemaName, tableName, e.toString()});
            }
        }
    }
}

