/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.control.numato.usbgpio;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.BitSet;
import net.solarnetwork.node.control.numato.usbgpio.GpioService;
import net.solarnetwork.node.control.numato.usbgpio.UsbGpioCommand;
import net.solarnetwork.node.io.serial.SerialConnection;
import net.solarnetwork.node.io.serial.SerialConnectionAction;
import net.solarnetwork.util.ByteList;
import net.solarnetwork.util.ObjectUtils;

public class UsbGpioService
implements GpioService {
    public static final long DEFAULT_LISTEN_WAIT_MS = 200L;
    public static final int DEFAULT_GPIO_COUNT = 8;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final SerialConnection conn;
    private long listenWaitMs = 200L;
    private int gpioCount = 8;

    public UsbGpioService(SerialConnection conn) {
        this.conn = (SerialConnection)ObjectUtils.requireNonNullArgument((Object)conn, (String)"conn");
    }

    private <T> T perform(SerialConnectionAction<T> action) throws IOException {
        return (T)action.doWithConnection(this.conn);
    }

    private void sleep() {
        UsbGpioService.sleep(this.listenWaitMs);
    }

    private static void sleep(long ms) {
        if (ms < 1L) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String responseValue(CharSequence cmd, byte[] response) {
        int start = cmd.length() + 1;
        if (response == null || response.length <= start) {
            return null;
        }
        int end = response.length;
        if (end > 2) {
            if (response[end - 1] == 62) {
                --end;
            }
            if (response[end - 1] == 13) {
                --end;
            }
            if (response[end - 1] == 10) {
                --end;
            }
        }
        if (end <= start) {
            return null;
        }
        return new String(response, start, end - start, US_ASCII);
    }

    private byte[] drainInputBuffer(SerialConnection conn) throws IOException {
        ByteList buf = new ByteList();
        while (true) {
            this.sleep();
            byte[] data = conn.drainInputBuffer();
            if (data == null || data.length < 1) break;
            buf.addAll(data);
        }
        return buf.toArrayValue();
    }

    @Override
    public String getDeviceVersion() throws IOException {
        return this.perform(new SerialConnectionAction<String>(){

            public String doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.Version.getCommand());
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                byte[] data = UsbGpioService.this.drainInputBuffer(conn);
                return UsbGpioService.responseValue(buf, data);
            }
        });
    }

    @Override
    public String getId() throws IOException {
        return this.perform(new SerialConnectionAction<String>(){

            public String doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.IdGet.getCommand());
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                byte[] data = UsbGpioService.this.drainInputBuffer(conn);
                return UsbGpioService.responseValue(buf, data);
            }
        });
    }

    @Override
    public void setId(final String id) throws IOException {
        if (id == null) {
            return;
        }
        byte[] data = id.getBytes(US_ASCII);
        if (data.length != 8) {
            throw new IllegalArgumentException("The ID value must be exactly 8 characters.");
        }
        this.perform(new SerialConnectionAction<Void>(){

            public Void doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.IdSet.getCommand());
                buf.append(" ");
                buf.append(id);
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                UsbGpioService.this.drainInputBuffer(conn);
                return null;
            }
        });
    }

    @Override
    public boolean read(final int address) throws IOException {
        return this.perform(new SerialConnectionAction<Boolean>(){

            public Boolean doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.GpioRead.getCommand());
                buf.append(" ");
                buf.append(address);
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                byte[] data = UsbGpioService.this.drainInputBuffer(conn);
                String resp = UsbGpioService.responseValue(buf, data);
                if ("1".equals(resp)) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void set(final int address, final boolean value) throws IOException {
        this.perform(new SerialConnectionAction<Void>(){

            public Void doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                if (value) {
                    buf.append(UsbGpioCommand.GpioSet.getCommand());
                } else {
                    buf.append(UsbGpioCommand.GpioClear.getCommand());
                }
                buf.append(" ");
                buf.append(address);
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                UsbGpioService.this.drainInputBuffer(conn);
                return null;
            }
        });
    }

    @Override
    public int readAnalog(final int address) throws IOException {
        return this.perform(new SerialConnectionAction<Integer>(){

            public Integer doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.AdcRead.getCommand());
                buf.append(" ");
                buf.append(address);
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                byte[] data = UsbGpioService.this.drainInputBuffer(conn);
                String resp = UsbGpioService.responseValue(buf, data);
                if (resp != null && !resp.isEmpty()) {
                    try {
                        return Integer.valueOf(resp);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Error parsing " + UsbGpioCommand.AdcRead.getCommand() + " response [" + resp + "]: " + e.getMessage(), e);
                    }
                }
                return 0;
            }
        });
    }

    @Override
    public BitSet readAll() throws IOException {
        return this.perform(new SerialConnectionAction<BitSet>(){

            public BitSet doWithConnection(SerialConnection conn) throws IOException {
                BitSet result;
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.GpioReadAll.getCommand());
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                byte[] data = UsbGpioService.this.drainInputBuffer(conn);
                String resp = UsbGpioService.responseValue(buf, data);
                if (resp != null && !resp.isEmpty()) {
                    try {
                        long l = Long.parseUnsignedLong(resp, 16);
                        result = BitSet.valueOf(new long[]{l});
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Error parsing " + UsbGpioCommand.GpioReadAll.getCommand() + " response [" + resp + "]: " + e.getMessage(), e);
                    }
                } else {
                    result = new BitSet();
                }
                return result;
            }
        });
    }

    private String hexCommandValue(BitSet set) {
        long[] setData = set != null ? set.toLongArray() : null;
        long data = setData != null && setData.length > 0 ? setData[setData.length - 1] : 0L;
        Object s = Long.toHexString(data);
        while (((String)s).length() < this.gpioCount / 8 * 2) {
            s = "0" + (String)s;
        }
        return s;
    }

    @Override
    public void writeAll(final BitSet values) throws IOException {
        this.perform(new SerialConnectionAction<Void>(){

            public Void doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.GpioWriteAll.getCommand());
                buf.append(" ");
                buf.append(UsbGpioService.this.hexCommandValue(values));
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                UsbGpioService.this.drainInputBuffer(conn);
                return null;
            }
        });
    }

    @Override
    public void configureWriteMask(final BitSet set) throws IOException {
        this.perform(new SerialConnectionAction<Void>(){

            public Void doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.GpioIoMask.getCommand());
                buf.append(" ");
                buf.append(UsbGpioService.this.hexCommandValue(set));
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                UsbGpioService.this.drainInputBuffer(conn);
                return null;
            }
        });
    }

    @Override
    public void configureIoDirection(final BitSet set) throws IOException {
        this.perform(new SerialConnectionAction<Void>(){

            public Void doWithConnection(SerialConnection conn) throws IOException {
                StringBuilder buf = new StringBuilder();
                buf.append(UsbGpioCommand.GpioIoDirection.getCommand());
                buf.append(" ");
                buf.append(UsbGpioService.this.hexCommandValue(set));
                buf.append('\r');
                conn.writeMessage(buf.toString().getBytes(US_ASCII));
                UsbGpioService.this.drainInputBuffer(conn);
                return null;
            }
        });
    }

    public long getListenWaitMs() {
        return this.listenWaitMs;
    }

    public void setListenWaitMs(long listenWaitMs) {
        this.listenWaitMs = listenWaitMs;
    }

    public int getGpioCount() {
        return this.gpioCount;
    }

    public void setGpioCount(int gpioCount) {
        if (gpioCount < 1) {
            throw new IllegalArgumentException("The gpioCount value must be greater than 0.");
        }
        this.gpioCount = gpioCount;
    }
}

