/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.control.numato.usbgpio;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.solarnetwork.domain.BasicNodeControlInfo;
import net.solarnetwork.domain.NodeControlInfo;
import net.solarnetwork.domain.NodeControlPropertyType;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.node.control.numato.usbgpio.GpioPropertyConfig;
import net.solarnetwork.node.control.numato.usbgpio.GpioService;
import net.solarnetwork.node.control.numato.usbgpio.GpioType;
import net.solarnetwork.node.control.numato.usbgpio.UsbGpioService;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.domain.datum.SimpleNodeControlInfoDatum;
import net.solarnetwork.node.io.serial.SerialConnection;
import net.solarnetwork.node.io.serial.SerialConnectionAction;
import net.solarnetwork.node.io.serial.SerialNetwork;
import net.solarnetwork.node.io.serial.support.SerialDeviceSupport;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionHandler;
import net.solarnetwork.node.reactor.InstructionStatus;
import net.solarnetwork.node.service.DatumEvents;
import net.solarnetwork.node.service.LockTimeoutException;
import net.solarnetwork.node.service.NodeControlProvider;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.SettingsChangeObserver;
import net.solarnetwork.settings.support.BasicGroupSettingSpecifier;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import net.solarnetwork.settings.support.SettingUtils;
import net.solarnetwork.util.ArrayUtils;
import org.osgi.service.event.Event;

public class GpioControl
extends SerialDeviceSupport
implements SettingSpecifierProvider,
NodeControlProvider,
InstructionHandler,
SettingsChangeObserver {
    public static final String DEFAULT_SERIAL_NETWORK_UID = "Serial Port";
    public static final int DEFAULT_GPIO_LOCK_TIMEOUT_SECS = 10;
    private final ReentrantLock gpioLock = new ReentrantLock(true);
    private GpioPropertyConfig[] propConfigs;
    private Function<SerialConnection, GpioService> serviceProvider = UsbGpioService::new;
    private CachedGpioService gpioService;
    private int gpioLockTimeoutSecs = 10;

    public GpioControl(OptionalService.OptionalFilterableService<SerialNetwork> serialNetwork) {
        super.setSerialNetwork(serialNetwork);
        this.setDisplayName("Numato USB GPIO Control");
        this.setSerialNetworkUid(DEFAULT_SERIAL_NETWORK_UID);
    }

    public void startup() {
        this.configurationChanged(null);
    }

    public void shutdown() {
        this.clearGpioService();
    }

    public synchronized void configurationChanged(Map<String, Object> properties) {
        try {
            this.performGpioAction(gpio -> null);
        }
        catch (IOException e) {
            this.clearGpioService();
        }
        catch (Exception e) {
            this.clearGpioService();
            Throwable root = e;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            this.log.error("Error opening GPIO serial port [{}]: {}", new Object[]{this.getSerialNetworkUid(), root.toString(), root});
        }
    }

    private synchronized GpioService gpioService() throws IOException {
        SerialNetwork serial;
        GpioService result;
        String serialNetworkUid = this.getSerialNetworkUid();
        if (serialNetworkUid == null) {
            this.clearGpioService();
            return null;
        }
        CachedGpioService cached = this.gpioService;
        if (cached != null && !serialNetworkUid.equals(cached.serialNetworkUid)) {
            this.clearGpioService();
        }
        GpioService gpioService = result = cached != null ? cached.gpioService : null;
        if (result == null && (serial = (SerialNetwork)OptionalService.service((OptionalService)this.getSerialNetwork())) != null) {
            SerialConnection conn = null;
            try {
                conn = serial.createConnection();
                conn.open();
                result = this.serviceProvider.apply(conn);
            }
            catch (IOException e) {
                if (conn != null) {
                    conn.close();
                }
                throw e;
            }
            this.gpioService = new CachedGpioService(serialNetworkUid, result, conn);
        }
        this.setupIoDirection(GpioPropertyConfig.ioDirectionBitSet(this.propConfigs), this.gpioService);
        return result;
    }

    private synchronized void clearGpioService() {
        if (this.gpioService != null && this.gpioService.conn != null) {
            try {
                this.gpioService.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.gpioService = null;
    }

    private synchronized void setupIoDirection(BitSet dirs, CachedGpioService cached) {
        if (cached == null) {
            return;
        }
        BitSet configuredDirection = cached.configuredDirection;
        if (dirs == null) {
            cached.configuredDirection = null;
            return;
        }
        if (dirs.equals(configuredDirection)) {
            return;
        }
        GpioService gpio = cached.gpioService;
        if (this.log.isInfoEnabled()) {
            this.log.info("Configuring GPIO direction on [{}] as inputs: {}", (Object)this.getSerialNetworkUid(), (Object)dirs);
        }
        try {
            gpio.configureIoDirection(dirs);
            cached.configuredDirection = dirs;
        }
        catch (IOException e) {
            this.log.error("Communication error setting GPIO direction on [{}]: {}", (Object)this.getSerialNetworkUid(), (Object)e.getMessage());
        }
    }

    public void setSerialNetwork(OptionalService.OptionalFilterableService<SerialNetwork> serialDevice) {
        throw new UnsupportedOperationException();
    }

    public boolean handlesTopic(String topic) {
        return "SetControlParameter".equals(topic);
    }

    public InstructionStatus processInstruction(Instruction instruction) {
        return null;
    }

    protected synchronized <T> T performAction(SerialConnectionAction<T> action) throws IOException {
        return (T)this.performGpioAction(gpio -> {
            CachedGpioService cached = this.gpioService;
            if (cached == null) {
                return null;
            }
            return action.doWithConnection(cached.conn);
        });
    }

    protected Map<String, Object> readDeviceInfo(SerialConnection conn) throws IOException {
        String v;
        GpioService gpio = this.serviceProvider.apply(conn);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        String id = gpio.getId();
        if (id != null) {
            result.put("Name", id);
        }
        if ((v = gpio.getDeviceVersion()) != null) {
            result.put("Model", v);
        }
        return result;
    }

    public List<String> getAvailableControlIds() {
        GpioPropertyConfig[] configs = this.getPropConfigs();
        if (configs == null || configs.length < 1) {
            return Collections.emptyList();
        }
        return Arrays.stream(configs).filter(GpioPropertyConfig::isValid).map(c -> this.resolvePlaceholders(c.getControlId())).collect(Collectors.toList());
    }

    public NodeControlInfo getCurrentControlInfo(String controlId) {
        GpioPropertyConfig config = this.configForControlId(controlId);
        if (config == null) {
            return null;
        }
        this.log.debug("Reading control [{}] status", (Object)controlId);
        SimpleNodeControlInfoDatum result = null;
        try {
            result = this.performGpioAction(gpio -> this.currentValue(config, gpio));
        }
        catch (IOException e) {
            this.clearGpioService();
            this.log.error("Communication error reading control [{}] status on [{}]: {}", new Object[]{controlId, this.getSerialNetworkUid(), e.getMessage()});
        }
        catch (Exception e) {
            this.clearGpioService();
            Throwable root = e;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            this.log.error("Error reading control [{}] status on [{}]: {}", new Object[]{controlId, this.getSerialNetworkUid(), root.toString(), root});
        }
        if (result != null) {
            this.postControlEvent("net/solarnetwork/node/service/NodeControlProvider/CONTROL_INFO_CAPTURED", result);
        }
        return result;
    }

    private void postControlEvent(String topic, SimpleNodeControlInfoDatum info) {
        Event event = DatumEvents.datumEvent((String)topic, (NodeDatum)info);
        this.postEvent(event);
    }

    private SimpleNodeControlInfoDatum currentValue(GpioPropertyConfig config, GpioService gpio) throws IOException {
        Integer addr = config.getAddress();
        if (addr == null || addr < 0) {
            return null;
        }
        Serializable value = null;
        if (config.getGpioType() == GpioType.Analog) {
            int v = gpio.readAnalog(addr);
            value = config.applyTransformations(v);
        } else {
            value = gpio.read(addr);
        }
        return this.createDatum(config, value);
    }

    private <T> T performGpioAction(GpioServiceAction<T> action) throws IOException {
        block16: {
            if (this.gpioLock.isHeldByCurrentThread()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("GPIO {} lock already acquired", (Object)this.getSerialNetworkUid());
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Acquiring lock on GPIO {}; waiting at most {}s", (Object)this.getSerialNetworkUid(), (Object)this.gpioLockTimeoutSecs);
                }
                try {
                    if (this.gpioLock.tryLock(this.gpioLockTimeoutSecs, TimeUnit.SECONDS)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Acquired GPIO {} lock", (Object)this.getSerialNetworkUid());
                        }
                        break block16;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Timeout acquiring GPIO {} lock", (Object)this.getSerialNetworkUid());
                    }
                    throw new LockTimeoutException("Could not acquire GPIO port " + this.getSerialNetworkUid() + " lock");
                }
                catch (InterruptedException e) {
                    this.log.debug("Interrupted waiting for GPIO {} lock", (Object)this.getSerialNetworkUid());
                    throw new LockTimeoutException("Could not acquire GPIO port " + this.getSerialNetworkUid() + " lock");
                }
            }
        }
        try {
            GpioService gpio = this.gpioService();
            if (gpio == null) {
                T t = null;
                return t;
            }
            T t = action.perform(gpio);
            return t;
        }
        catch (IOException e) {
            this.clearGpioService();
            this.log.error("Communication error using GPIO serial port [{}]: {}", (Object)this.getSerialNetworkUid(), (Object)e.getMessage());
            throw e;
        }
        finally {
            this.gpioLock.unlock();
        }
    }

    private SimpleNodeControlInfoDatum createDatum(GpioPropertyConfig config, Object value) {
        String propName;
        Object o;
        BasicNodeControlInfo info = BasicNodeControlInfo.builder().withControlId(this.resolvePlaceholders(config.getControlId())).withType(config.getGpioType() == GpioType.Analog ? NodeControlPropertyType.Float : NodeControlPropertyType.Boolean).withPropertyName(config.getPropertyKey()).withReadonly(Boolean.valueOf(true)).withValue(value != null ? value.toString() : null).build();
        SimpleNodeControlInfoDatum d = new SimpleNodeControlInfoDatum((NodeControlInfo)info, Instant.now());
        if (config.getPropertyType() != null && config.getPropertyType() != DatumSamplesType.Status && (o = d.getSampleValue(DatumSamplesType.Status, propName = config.getPropertyKey() != null ? config.getPropertyKey() : "val")) instanceof Number) {
            d.putSampleValue(config.getPropertyType(), propName, o);
            d.putSampleValue(DatumSamplesType.Status, propName, null);
            Map statusMap = d.getSampleData(DatumSamplesType.Status);
            if (statusMap != null && statusMap.isEmpty()) {
                d.setSampleData(DatumSamplesType.Status, null);
            }
        }
        return d;
    }

    private GpioPropertyConfig configForControlId(String controlId) {
        GpioPropertyConfig[] configs = this.getPropConfigs();
        if (controlId == null || configs == null || configs.length < 1) {
            return null;
        }
        for (GpioPropertyConfig config : configs) {
            if (!controlId.equals(this.resolvePlaceholders(config.getControlId()))) continue;
            return config;
        }
        return null;
    }

    public String getSettingUid() {
        return "net.solarnetwork.node.control.numato.usbgpio";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(20);
        results.add((SettingSpecifier)new BasicTitleSettingSpecifier("info", this.getDeviceInfoMessage(), true));
        results.addAll(GpioControl.baseIdentifiableSettings((String)""));
        results.addAll(GpioControl.serialNetworkSettings((String)"", (String)DEFAULT_SERIAL_NETWORK_UID));
        GpioPropertyConfig[] confs = this.getPropConfigs();
        List<Object> confsList = confs != null ? Arrays.asList(confs) : Collections.emptyList();
        results.add((SettingSpecifier)SettingUtils.dynamicListSettingSpecifier((String)"propConfigs", confsList, (SettingUtils.KeyedListCallback)new SettingUtils.KeyedListCallback<GpioPropertyConfig>(){

            public Collection<SettingSpecifier> mapListSettingKey(GpioPropertyConfig value, int index, String key) {
                BasicGroupSettingSpecifier configGroup = new BasicGroupSettingSpecifier(GpioPropertyConfig.settings(key + "."));
                return Collections.singletonList(configGroup);
            }
        }));
        return results;
    }

    public GpioPropertyConfig[] getPropConfigs() {
        return this.propConfigs;
    }

    public void setPropConfigs(GpioPropertyConfig[] propConfigs) {
        this.propConfigs = propConfigs;
    }

    public int getPropConfigsCount() {
        GpioPropertyConfig[] confs = this.propConfigs;
        return confs == null ? 0 : confs.length;
    }

    public void setPropConfigsCount(int count) {
        this.propConfigs = (GpioPropertyConfig[])ArrayUtils.arrayWithLength((Object[])this.propConfigs, (int)count, GpioPropertyConfig.class, null);
    }

    public Function<SerialConnection, GpioService> getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(Function<SerialConnection, GpioService> serviceProvider) {
        if (serviceProvider == null) {
            serviceProvider = UsbGpioService::new;
        }
        this.serviceProvider = serviceProvider;
    }

    public int getGpioLockTimeoutSecs() {
        return this.gpioLockTimeoutSecs;
    }

    public void setGpioLockTimeoutSecs(int gpioLockTimeoutSecs) {
        this.gpioLockTimeoutSecs = gpioLockTimeoutSecs;
    }

    @FunctionalInterface
    public static interface GpioServiceAction<T> {
        public T perform(GpioService var1) throws IOException;
    }

    private static final class CachedGpioService {
        private final String serialNetworkUid;
        private final GpioService gpioService;
        private final SerialConnection conn;
        private BitSet configuredDirection;

        private CachedGpioService(String serialNetworkUid, GpioService gpioService, SerialConnection conn) {
            if (serialNetworkUid == null || gpioService == null || conn == null) {
                throw new IllegalArgumentException("No argumnet may be null.");
            }
            this.serialNetworkUid = serialNetworkUid;
            this.gpioService = gpioService;
            this.conn = conn;
        }
    }
}

