/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.control.numato.usbgpio;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import net.solarnetwork.domain.CodedValue;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.NumberDatumSamplePropertyConfig;
import net.solarnetwork.node.control.numato.usbgpio.GpioDirection;
import net.solarnetwork.node.control.numato.usbgpio.GpioType;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicMultiValueSettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;

public class GpioPropertyConfig
extends NumberDatumSamplePropertyConfig<Integer> {
    public static final GpioType DEFAULT_GPIO_TYPE = GpioType.Digital;
    public static final GpioDirection DEFAULT_GPIO_DIRECTION = GpioDirection.Input;
    private String controlId;
    private GpioType gpioType;
    private GpioDirection gpioDirection;

    public static List<SettingSpecifier> settings(String prefix) {
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(8);
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "controlId", null));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "propertyKey", null));
        BasicMultiValueSettingSpecifier propTypeSpec = new BasicMultiValueSettingSpecifier(prefix + "propertyTypeKey", String.valueOf(DEFAULT_PROPERTY_TYPE.toKey()));
        LinkedHashMap<String, String> propTypeTitles = new LinkedHashMap<String, String>(3);
        for (DatumSamplesType e : DatumSamplesType.values()) {
            propTypeTitles.put(Character.toString(e.toKey()), e.toString());
        }
        propTypeSpec.setValueTitles(propTypeTitles);
        result.add((SettingSpecifier)propTypeSpec);
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "address", null));
        BasicMultiValueSettingSpecifier gpioTypeSpec = new BasicMultiValueSettingSpecifier(prefix + "gpioTypeCode", String.valueOf(DEFAULT_GPIO_TYPE.getCode()));
        LinkedHashMap<String, String> gpioTypeTitles = new LinkedHashMap<String, String>(2);
        for (GpioType e : GpioType.values()) {
            gpioTypeTitles.put(String.valueOf(e.getCode()), e.toString());
        }
        gpioTypeSpec.setValueTitles(gpioTypeTitles);
        result.add((SettingSpecifier)gpioTypeSpec);
        BasicMultiValueSettingSpecifier gpioDirSpec = new BasicMultiValueSettingSpecifier(prefix + "gpioDirectionCode", String.valueOf(DEFAULT_GPIO_TYPE.getCode()));
        LinkedHashMap<String, String> gpioDirTitles = new LinkedHashMap<String, String>(2);
        for (GpioDirection e : GpioDirection.values()) {
            gpioDirTitles.put(String.valueOf(e.getCode()), e.toString());
        }
        gpioDirSpec.setValueTitles(gpioDirTitles);
        result.add((SettingSpecifier)gpioDirSpec);
        result.addAll(GpioPropertyConfig.numberTransformSettings((String)prefix));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "decimalScale", String.valueOf(5)));
        return result;
    }

    public static BitSet ioDirectionBitSet(GpioPropertyConfig[] configs) {
        int len;
        int n = len = configs != null ? configs.length : 0;
        if (len < 1) {
            return null;
        }
        BitSet result = new BitSet();
        for (int i = 0; i < len; ++i) {
            if (configs[i].gpioDirection != GpioDirection.Input || !configs[i].isValid()) continue;
            result.set(configs[i].getAddress());
        }
        return result;
    }

    public static GpioPropertyConfig of(String controlId, Integer address) {
        GpioPropertyConfig cfg = new GpioPropertyConfig();
        cfg.setControlId(controlId);
        cfg.setAddress(address);
        return cfg;
    }

    public GpioPropertyConfig() {
        this.setGpioType(DEFAULT_GPIO_TYPE);
        this.setGpioDirection(DEFAULT_GPIO_DIRECTION);
    }

    public boolean isValid() {
        Integer addr = this.getAddress();
        return this.controlId != null && this.controlId.trim().length() > 0 && addr != null && addr >= 0;
    }

    public String getControlId() {
        return this.controlId;
    }

    public void setControlId(String controlId) {
        this.controlId = controlId;
    }

    public Integer getAddress() {
        return (Integer)this.getConfig();
    }

    public void setAddress(Integer address) {
        this.setConfig(address);
    }

    public GpioType getGpioType() {
        return this.gpioType;
    }

    public void setGpioType(GpioType gpioType) {
        this.gpioType = gpioType != null ? gpioType : DEFAULT_GPIO_TYPE;
    }

    public int getGpioTypeCode() {
        return this.gpioType.getCode();
    }

    public void setGpioTypeCode(int code) {
        this.setGpioType((GpioType)CodedValue.forCodeValue((int)code, GpioType.class, null));
    }

    public GpioDirection getGpioDirection() {
        return this.gpioDirection;
    }

    public void setGpioDirection(GpioDirection gpioDirection) {
        this.gpioDirection = gpioDirection != null ? gpioDirection : DEFAULT_GPIO_DIRECTION;
    }

    public int getGpioDirectionCode() {
        return this.gpioDirection.getCode();
    }

    public void setGpioDirectionCode(int code) {
        this.setGpioDirection((GpioDirection)CodedValue.forCodeValue((int)code, GpioDirection.class, null));
    }
}

