/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.control.datumreactor;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.node.control.datumreactor.ControlPropertyConfig;
import net.solarnetwork.node.control.datumreactor.ExpressionRoot;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionExecutionService;
import net.solarnetwork.node.reactor.InstructionStatus;
import net.solarnetwork.node.reactor.InstructionUtils;
import net.solarnetwork.node.service.DatumService;
import net.solarnetwork.node.service.OperationalModesService;
import net.solarnetwork.node.service.PlaceholderService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.OptionalServiceCollection;
import net.solarnetwork.service.support.ExpressionServiceExpression;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import net.solarnetwork.util.DateUtils;
import net.solarnetwork.util.NumberUtils;
import net.solarnetwork.util.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.springframework.expression.ExpressionException;

public class DatumStreamReactor
extends BaseIdentifiable
implements SettingSpecifierProvider,
EventHandler {
    public static final String DEFAULT_INSTRUCTION_TOPIC = "SetControlParameter";
    private final ControlPropertyConfig config = new ControlPropertyConfig();
    private Executor executor;
    private Pattern sourceIdRegex;
    private String instructionTopic = "SetControlParameter";
    private OptionalService<InstructionExecutionService> instructionExecutionService;
    private OptionalService<DatumService> datumService;
    private OptionalService<OperationalModesService> opModesService;
    private Instruction lastInstruction;
    private InstructionStatus lastInstructionResult;

    public void handleEvent(Event event) {
        String[] stringArray;
        if (!this.config.isValid()) {
            return;
        }
        String topic = event.getTopic();
        if (!"net/solarnetwork/node/DatumQueue/DATUM_ACQUIRED".equals(topic)) {
            return;
        }
        Object val = event.getProperty("_Datum");
        if (val == null || !(val instanceof NodeDatum)) {
            return;
        }
        final NodeDatum datum = (NodeDatum)val;
        Pattern sourceIdRegex = this.getSourceIdRegex();
        if (sourceIdRegex != null) {
            stringArray = StringUtils.match((Pattern)sourceIdRegex, (String)datum.getSourceId());
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = datum.getSourceId();
        }
        String[] sourceIdMatch = stringArray;
        if (sourceIdMatch == null) {
            this.log.debug("Ignoring datum: ID {} does not match pattern {}", (Object)datum.getSourceId(), (Object)sourceIdRegex);
            return;
        }
        final String controlId = this.controlId(sourceIdMatch);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object desiredControlValue = null;
                Instruction instr = null;
                InstructionStatus instrResult = null;
                try {
                    if (DatumStreamReactor.this.config.getExpression() != null && DatumStreamReactor.this.config.getExpressionServiceId() != null) {
                        desiredControlValue = DatumStreamReactor.this.evaluateExpression(datum, controlId);
                    }
                    desiredControlValue = DatumStreamReactor.this.applyNumberConstraints(desiredControlValue);
                    if (DatumStreamReactor.this.log.isDebugEnabled()) {
                        DatumStreamReactor.this.log.debug("Reaction to input {} to {} on control [{}]: {}", new Object[]{datum, DatumStreamReactor.this.instructionTopic, controlId, desiredControlValue});
                    }
                    if (desiredControlValue == null) {
                        return;
                    }
                    InstructionExecutionService instrService = (InstructionExecutionService)OptionalService.service((OptionalService)DatumStreamReactor.this.instructionExecutionService);
                    instr = InstructionUtils.createLocalInstruction((String)DatumStreamReactor.this.instructionTopic, (String)controlId, (String)(desiredControlValue instanceof Number ? NumberUtils.bigDecimalForNumber((Number)((Number)desiredControlValue)).toPlainString() : desiredControlValue.toString()));
                    instrResult = instrService != null ? instrService.executeInstruction(instr) : InstructionUtils.createStatus((Instruction)instr, (InstructionStatus.InstructionState)InstructionStatus.InstructionState.Declined, Collections.singletonMap("message", "No InstructionExecutionService available."));
                }
                catch (ExpressionException e) {
                    instr = InstructionUtils.createLocalInstruction((String)DatumStreamReactor.this.instructionTopic, (String)controlId, (String)"-1");
                    instrResult = InstructionUtils.createStatus((Instruction)instr, (InstructionStatus.InstructionState)InstructionStatus.InstructionState.Declined, Collections.singletonMap("message", String.format("Exception evaluating expression [%s]: %s", DatumStreamReactor.this.config.getExpression(), e.getMessage())));
                }
                catch (RuntimeException e) {
                    instrResult = InstructionUtils.createStatus((Instruction)instr, (InstructionStatus.InstructionState)InstructionStatus.InstructionState.Declined, Collections.singletonMap("message", "Exception handling instruction: " + e.toString()));
                }
                if (instrResult == null) {
                    DatumStreamReactor.this.log.warn("Unable to {} on control [{}] with [{}]: control not available", new Object[]{DatumStreamReactor.this.instructionTopic, controlId, desiredControlValue});
                } else if (instrResult.getInstructionState() != InstructionStatus.InstructionState.Completed) {
                    DatumStreamReactor.this.log.warn("Failed to {} control [{}] with [{}] (instruction result {}): {}", new Object[]{DatumStreamReactor.this.instructionTopic, controlId, desiredControlValue, instrResult, instrResult.getResultParameters()});
                }
                1 var4_4 = this;
                synchronized (var4_4) {
                    DatumStreamReactor.this.lastInstruction = instr;
                    DatumStreamReactor.this.lastInstructionResult = instrResult;
                }
            }
        };
        Executor e = this.executor;
        if (e != null) {
            e.execute(task);
        } else {
            task.run();
        }
    }

    private String controlId(String[] sourceIdMatch) {
        String controlId = this.getConfig().getControlId();
        HashMap<String, String> params = null;
        if (sourceIdMatch != null && sourceIdMatch.length > 1) {
            params = new HashMap<String, String>(sourceIdMatch.length);
            for (int i = 1; i < sourceIdMatch.length; ++i) {
                params.put(String.valueOf(i), sourceIdMatch[i]);
            }
        }
        return this.resolvePlaceholders(controlId, params);
    }

    private Object evaluateExpression(NodeDatum datum, String controlId) {
        ExpressionServiceExpression expr;
        HashMap parameters = new HashMap(8);
        PlaceholderService.smartCopyPlaceholders((OptionalService)this.getPlaceholderService(), parameters);
        Object result = null;
        Iterable services = OptionalServiceCollection.services((OptionalServiceCollection)this.getExpressionServices());
        ExpressionRoot root = ExpressionRoot.of(datum, (DatumService)OptionalService.service(this.datumService), (OperationalModesService)OptionalService.service(this.opModesService), this.config.getMinValue(), this.config.getMaxValue(), parameters);
        root.setLocalStateDao(this.getLocalStateDao());
        try {
            expr = this.config.getExpression(services);
        }
        catch (ExpressionException e) {
            this.log.warn("Error parsing expression `{}`: {}", (Object)this.config.getExpression(), (Object)e.getMessage());
            return null;
        }
        if (expr != null) {
            try {
                result = expr.getService().evaluateExpression(expr.getExpression(), null, (Object)root, null, Object.class);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Service [{}] evaluated control [{}] expression `{}` \u2192 {}\n\nExpression root: {}", new Object[]{this.getUid(), controlId, this.config.getExpression(), result, root});
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Service [{}] evaluated control [{}] expression `{}` \u2192 {}", new Object[]{this.getUid(), controlId, this.config.getExpression(), result});
                }
            }
            catch (ExpressionException e) {
                this.log.warn("Error evaluating service [{}] control [{}] expression `{}`: {}\n\nExpression root: {}", new Object[]{this.getUid(), controlId, this.config.getExpression(), e.getMessage(), root, e});
                throw e;
            }
        }
        return result;
    }

    private Object applyNumberConstraints(Object result) {
        if (!(result instanceof Number)) {
            return result;
        }
        if (this.config.getMinValue() != null || this.config.getMaxValue() != null) {
            BigDecimal resultDecimal = NumberUtils.bigDecimalForNumber((Number)((Number)result));
            if (this.config.getMinValue() != null && resultDecimal.compareTo(this.config.getMinValue()) < 0) {
                result = this.config.getMinValue();
            } else if (this.config.getMaxValue() != null && resultDecimal.compareTo(this.config.getMaxValue()) > 0) {
                result = this.config.getMaxValue();
            }
        }
        return result;
    }

    public String getSettingUid() {
        return "net.solarnetwork.node.control.datumreactor";
    }

    public String getDisplayName() {
        return "Load Balancer";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(4);
        results.add((SettingSpecifier)new BasicTitleSettingSpecifier("status", this.getStatusMessage()));
        results.add((SettingSpecifier)new BasicTitleSettingSpecifier("statusDate", this.getStatusMessageDate()));
        results.addAll(DatumStreamReactor.baseIdentifiableSettings((String)""));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("sourceIdRegexValue", ""));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("instructionTopic", DEFAULT_INSTRUCTION_TOPIC));
        results.addAll(ControlPropertyConfig.settings("config.", OptionalServiceCollection.services((OptionalServiceCollection)this.getExpressionServices())));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatusMessage() {
        InstructionStatus instrResult;
        Instruction instr;
        DatumStreamReactor datumStreamReactor = this;
        synchronized (datumStreamReactor) {
            instr = this.lastInstruction;
            instrResult = this.lastInstructionResult;
        }
        if (instr == null) {
            return "N/A";
        }
        String controlId = (String)instr.getParameterNames().iterator().next();
        String controlVal = instr.getParameterValue(controlId);
        if (instrResult == null) {
            return this.getMessageSource().getMessage("error.missingControl", new Object[]{instr.getTopic(), controlId, controlVal}, "Control not available.", Locale.getDefault());
        }
        if (instrResult.getInstructionState() == InstructionStatus.InstructionState.Completed) {
            return this.getMessageSource().getMessage("status.ok", new Object[]{instr.getTopic(), controlId, controlVal}, "Control instruction executed.", Locale.getDefault());
        }
        return this.getMessageSource().getMessage("error.failSetControl", new Object[]{instr.getTopic(), controlId, controlVal, instrResult.getInstructionState(), instrResult.getResultParameters() != null && !instrResult.getResultParameters().isEmpty() ? instrResult.getResultParameters() : this.getMessageSource().getMessage("error.noInstructionResultParameters", null, "No result information available.", Locale.getDefault())}, "Failed to execute control instruction.", Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatusMessageDate() {
        Instruction instr;
        DatumStreamReactor datumStreamReactor = this;
        synchronized (datumStreamReactor) {
            instr = this.lastInstruction;
        }
        if (instr == null) {
            return "N/A";
        }
        return DateUtils.formatForLocalDisplay((Instant)instr.getInstructionDate());
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Pattern getSourceIdRegex() {
        return this.sourceIdRegex;
    }

    public void setSourceIdRegex(Pattern sourceIdRegex) {
        this.sourceIdRegex = sourceIdRegex;
    }

    public String getSourceIdRegexValue() {
        Pattern p = this.getSourceIdRegex();
        return p != null ? p.pattern() : null;
    }

    public void setSourceIdRegexValue(String sourceIdRegex) {
        Pattern p = null;
        if (sourceIdRegex != null) {
            try {
                p = Pattern.compile(sourceIdRegex, 2);
            }
            catch (PatternSyntaxException e) {
                this.log.error("Invalid source ID pattern [{}]: {}", (Object)sourceIdRegex, (Object)e.getMessage());
            }
        }
        this.setSourceIdRegex(p);
    }

    public ControlPropertyConfig getConfig() {
        return this.config;
    }

    public void setInstructionExecutionService(OptionalService<InstructionExecutionService> instructionExecutionService) {
        this.instructionExecutionService = instructionExecutionService;
    }

    public void setDatumService(OptionalService<DatumService> datumService) {
        this.datumService = datumService;
    }

    public String getInstructionTopic() {
        return this.instructionTopic;
    }

    public void setInstructionTopic(String instructionTopic) {
        this.instructionTopic = instructionTopic != null ? instructionTopic : DEFAULT_INSTRUCTION_TOPIC;
    }

    public OptionalService<OperationalModesService> getOpModesService() {
        return this.opModesService;
    }

    public void setOpModesService(OptionalService<OperationalModesService> opModesService) {
        this.opModesService = opModesService;
    }
}

