/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.control.datumreactor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.solarnetwork.node.service.support.ExpressionConfig;
import net.solarnetwork.service.ExpressionService;
import net.solarnetwork.settings.KeyedSettingSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;

public class ControlPropertyConfig
extends ExpressionConfig {
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private String controlId;

    public static List<SettingSpecifier> settings(String prefix, Iterable<ExpressionService> expressionServices) {
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(8);
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "controlId", null));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "minValue", null));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "maxValue", null));
        result.addAll(ExpressionConfig.settings(ControlPropertyConfig.class, (String)prefix, expressionServices).stream().filter(s -> {
            KeyedSettingSpecifier kss;
            String key;
            return !(s instanceof KeyedSettingSpecifier) || !(key = (kss = (KeyedSettingSpecifier)s).getKey()).endsWith(".datumPropertyTypeKey") && !key.endsWith(".name");
        }).collect(Collectors.toList()));
        return result;
    }

    public static ControlPropertyConfig of(String controlId) {
        ControlPropertyConfig cfg = new ControlPropertyConfig();
        cfg.setControlId(controlId);
        return cfg;
    }

    public boolean isValid() {
        String controlId = this.getControlId();
        return controlId != null && controlId.trim().length() > 0;
    }

    public String getControlId() {
        return this.controlId;
    }

    public void setControlId(String controlId) {
        this.controlId = controlId;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }
}

