/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.external.indriya.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.measure.spi.ServiceProvider;
import net.solarnetwork.external.indriya.IndriyaMeasurementServiceProvider;
import net.solarnetwork.javax.measure.MeasurementServiceProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import si.uom.SIServiceProvider;
import systems.uom.common.spi.CommonServiceProvider;
import systems.uom.ucum.spi.UCUMServiceProvider;
import systems.uom.unicode.spi.UnicodeServiceProvider;
import tech.units.indriya.spi.DefaultServiceProvider;

public class Activator
implements BundleActivator {
    private final Collection<ServiceRegistration<MeasurementServiceProvider>> registrations = new ArrayList<ServiceRegistration<MeasurementServiceProvider>>(4);

    public void start(BundleContext bundleContext) throws Exception {
        this.registerServiceProvider(bundleContext, (ServiceProvider)new UCUMServiceProvider(), "UCUM");
        this.registerServiceProvider(bundleContext, (ServiceProvider)new CommonServiceProvider(), "Common");
        this.registerServiceProvider(bundleContext, (ServiceProvider)new SIServiceProvider(), "SI");
        this.registerServiceProvider(bundleContext, (ServiceProvider)new UnicodeServiceProvider(), "Unicode");
        this.registerServiceProvider(bundleContext, (ServiceProvider)new DefaultServiceProvider(), "Default");
    }

    private void registerServiceProvider(BundleContext bundleContext, ServiceProvider provider, String name) {
        this.setupServiceProvider(provider);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("service.name", name);
        properties.put("service.ranking", provider.getPriority());
        properties.put("service.vendor", "Indriya");
        IndriyaMeasurementServiceProvider s = new IndriyaMeasurementServiceProvider(provider);
        this.registrations.add((ServiceRegistration<MeasurementServiceProvider>)bundleContext.registerService(MeasurementServiceProvider.class, (Object)s, properties));
    }

    private void setupServiceProvider(ServiceProvider provider) {
        provider.getFormatService();
        provider.getUnitFormatService();
        provider.getSystemOfUnitsService();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        Iterator<ServiceRegistration<MeasurementServiceProvider>> itr = this.registrations.iterator();
        while (itr.hasNext()) {
            ServiceRegistration<MeasurementServiceProvider> reg = itr.next();
            if (reg == null) continue;
            reg.unregister();
            itr.remove();
        }
    }
}

