/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.platform;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoProcessor;
import org.apache.felix.main.Main;
import org.eclipse.gemini.blueprint.test.internal.util.IOUtils;
import org.eclipse.gemini.blueprint.test.platform.AbstractOsgiPlatform;
import org.eclipse.gemini.blueprint.test.platform.DefaultFrameworkTemplate;
import org.eclipse.gemini.blueprint.test.platform.FrameworkTemplate;
import org.eclipse.gemini.blueprint.test.platform.Platform;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public class FelixPlatform
extends AbstractOsgiPlatform {
    private static final Log log = LogFactory.getLog(FelixPlatform.class);
    private static final String FELIX_PROFILE_DIR_PROPERTY = "felix.cache.profiledir";
    private static final String OSGI_STORAGE_PROPERTY = "org.osgi.framework.storage";
    private BundleContext context;
    private File felixStorageDir;
    private Platform platform;

    public FelixPlatform() {
        this.toString = "Felix OSGi Platform";
    }

    @Override
    Properties getPlatformProperties() {
        Properties props = new Properties();
        this.createStorageDir(props);
        props.put("felix.log.level", "0");
        props.put("felix.embedded.execution", "true");
        return props;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.context;
    }

    private void createStorageDir(Properties configProperties) {
        if (this.felixStorageDir == null) {
            this.felixStorageDir = this.createTempDir("felix");
            this.felixStorageDir.deleteOnExit();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Felix storage dir is " + this.felixStorageDir.getAbsolutePath()));
            }
        }
        configProperties.setProperty(FELIX_PROFILE_DIR_PROPERTY, this.felixStorageDir.getAbsolutePath());
        configProperties.setProperty(OSGI_STORAGE_PROPERTY, this.felixStorageDir.getAbsolutePath());
        configProperties.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
    }

    @Override
    public void start() throws Exception {
        if (this.platform == null) {
            Properties configProperties = this.getConfigurationProperties();
            System.getProperties().putAll((Map<?, ?>)configProperties);
            this.platform = new Felix20XPlatform(LogFactory.getLog(Felix20XPlatform.class));
            this.context = this.platform.start();
        }
    }

    private static Map<String, String> getConfiguration() {
        Main.loadSystemProperties();
        HashMap<String, String> configProps = Main.loadConfigProperties();
        if (configProps == null) {
            configProps = new HashMap<String, String>();
        }
        Main.copySystemProperties((Map)configProps);
        return configProps;
    }

    @Override
    public void stop() throws Exception {
        if (this.platform != null) {
            try {
                this.platform.stop();
            }
            finally {
                this.context = null;
                this.platform = null;
                IOUtils.delete(this.felixStorageDir);
            }
        }
    }

    private static class Felix20XPlatform
    implements Platform {
        private FrameworkTemplate fwkTemplate;
        private final Log log;

        Felix20XPlatform(Log log) {
            this.log = log;
        }

        @Override
        public BundleContext start() throws Exception {
            Map configMap = FelixPlatform.getConfiguration();
            Felix fx = new Felix(configMap);
            this.fwkTemplate = new DefaultFrameworkTemplate(fx, this.log);
            this.fwkTemplate.init();
            BundleContext context = fx.getBundleContext();
            AutoProcessor.process((Map)configMap, (BundleContext)context);
            this.fwkTemplate.start();
            return context;
        }

        @Override
        public void stop() throws Exception {
            this.fwkTemplate.stopAndWait(1000L);
        }
    }

    private static abstract class Felix1XPlatform
    implements Platform {
        private static final Constructor<?> CTOR;
        private Felix felix;

        private Felix1XPlatform() {
        }

        @Override
        public final BundleContext start() throws Exception {
            Map configMap = FelixPlatform.getConfiguration();
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(BeanUtils.instantiateClass(CTOR, (Object[])new Object[]{configMap}));
            this.felix = this.createFelix(configMap, list);
            this.felix.start();
            return this.felix.getBundleContext();
        }

        @Override
        public final void stop() throws Exception {
            this.felix.stop();
        }

        abstract Felix createFelix(Map<String, String> var1, List<?> var2) throws Exception;

        static {
            Class autoActivator = ClassUtils.resolveClassName((String)"org.apache.felix.main.AutoActivator", (ClassLoader)Felix1XPlatform.class.getClassLoader());
            try {
                CTOR = autoActivator.getConstructor(Map.class);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot instantiate class " + autoActivator, ex);
            }
        }
    }
}

