/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.platform;

import org.apache.commons.logging.Log;
import org.eclipse.gemini.blueprint.test.platform.FrameworkTemplate;
import org.eclipse.gemini.blueprint.util.OsgiPlatformDetector;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.springframework.util.Assert;

class DefaultFrameworkTemplate
implements FrameworkTemplate {
    private final Framework fwk;
    private final Log log;

    public DefaultFrameworkTemplate(Object target, Log log) {
        if (!OsgiPlatformDetector.isR42()) {
            throw new IllegalStateException("Cannot use OSGi 4.2 Framework API in an OSGi 4.1 environment");
        }
        Assert.isInstanceOf(Framework.class, (Object)target);
        this.fwk = (Framework)target;
        this.log = log;
    }

    @Override
    public void init() {
        try {
            this.fwk.init();
        }
        catch (BundleException ex) {
            throw new IllegalStateException("Cannot initialize framework", ex);
        }
    }

    @Override
    public void start() {
        try {
            this.fwk.start();
        }
        catch (BundleException ex) {
            throw new IllegalStateException("Cannot start framework", ex);
        }
    }

    @Override
    public void stopAndWait(long delay) {
        try {
            this.fwk.stop();
        }
        catch (BundleException ex) {
            this.log.error((Object)"Cannot stop framework", (Throwable)ex);
        }
        try {
            this.fwk.waitForStop(delay);
        }
        catch (InterruptedException ex) {
            this.log.error((Object)"Waiting for framework to stop interrupted", (Throwable)ex);
        }
    }
}

