/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.util.jar.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.gemini.blueprint.test.internal.util.jar.storage.Storage;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileSystemStorage
implements Storage {
    private File storage;
    private static final String TEMP_FILE_PREFIX = "spring.osgi";

    public FileSystemStorage() {
        try {
            this.storage = File.createTempFile(TEMP_FILE_PREFIX, null);
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot create temporary file", ex);
        }
        this.storage.deleteOnExit();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.storage));
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot return file stream", ex);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return new BufferedOutputStream(new FileOutputStream(this.storage));
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot return file stream", ex);
        }
    }

    @Override
    public void dispose() {
        this.storage.delete();
    }

    @Override
    public Resource getResource() {
        return new FileSystemResource(this.storage);
    }
}

