/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.util.jar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.springframework.core.io.Resource;

public abstract class JarUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String MANIFEST_JAR_LOCATION = "/META-INF/MANIFEST.MF";
    static final String SLASH = "/";

    public static String dumpJarContent(JarInputStream jis) {
        StringBuilder buffer = new StringBuilder();
        try {
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                buffer.append(entry.getName());
                buffer.append("\n");
            }
        }
        catch (IOException ioException) {
            buffer.append("reading from stream failed");
        }
        finally {
            JarUtils.closeStream(jis);
        }
        return buffer.toString();
    }

    public static String dumpJarContent(Resource resource) {
        try {
            return JarUtils.dumpJarContent(new JarInputStream(resource.getInputStream()));
        }
        catch (IOException ex) {
            return "reading from stream failed" + ex;
        }
    }

    public static int writeToJar(Resource res, String entryName, JarOutputStream jarStream) throws IOException {
        return JarUtils.writeToJar(res, entryName, jarStream, 4096);
    }

    public static int writeToJar(Resource res, String entryName, JarOutputStream jarStream, int bufferSize) throws IOException {
        int numberOfBytes;
        byte[] readWriteJarBuffer = new byte[bufferSize];
        if (entryName.charAt(0) == '/') {
            entryName = entryName.substring(1);
        }
        jarStream.putNextEntry(new ZipEntry(entryName));
        InputStream entryStream = res.getInputStream();
        while ((numberOfBytes = entryStream.read(readWriteJarBuffer)) != -1) {
            jarStream.write(readWriteJarBuffer, 0, numberOfBytes);
        }
        return numberOfBytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Manifest getManifest(InputStream stream) {
        Manifest manifest;
        JarInputStream myStream = null;
        try {
            myStream = new JarInputStream(stream);
            manifest = myStream.getManifest();
        }
        catch (IOException iOException) {
            JarUtils.closeStream(myStream);
            return null;
        }
        catch (Throwable throwable) {
            JarUtils.closeStream(myStream);
            throw throwable;
        }
        JarUtils.closeStream(myStream);
        return manifest;
    }

    public static Manifest getManifest(Resource resource) {
        try {
            return JarUtils.getManifest(resource.getInputStream());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createJar(Manifest manifest, Map entries, OutputStream outputStream) throws IOException {
        int writtenBytes = 0;
        DeflaterOutputStream jarStream = null;
        try {
            jarStream = manifest != null ? new JarOutputStream(outputStream, manifest) : new JarOutputStream(outputStream);
            ((ZipOutputStream)jarStream).setLevel(0);
            Iterator iter = entries.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry element = iter.next();
                String entryName = (String)element.getKey();
                if (!entryName.startsWith(SLASH)) {
                    entryName = SLASH + entryName;
                }
                Resource entryValue = (Resource)element.getValue();
                if (MANIFEST_JAR_LOCATION.equals(entryName)) {
                    iter.remove();
                    continue;
                }
                writtenBytes += JarUtils.writeToJar(entryValue, entryName, (JarOutputStream)jarStream);
            }
        }
        finally {
            try {
                jarStream.flush();
            }
            catch (IOException iOException) {}
            try {
                ((ZipOutputStream)jarStream).finish();
            }
            catch (IOException iOException) {}
        }
        return writtenBytes;
    }

    private static void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

