/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class IOUtils {
    public static void doWithIO(IOCallback callback) {
        try {
            callback.doWithIO();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        boolean success = true;
        if (file.isDirectory()) {
            String[] children;
            for (String aChildren : children = file.list()) {
                success &= IOUtils.delete(new File(file, aChildren));
            }
        }
        return success &= file.delete();
    }

    public static interface IOCallback {
        public void doWithIO() throws IOException;
    }
}

