/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.util;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class DependencyVisitor
extends ClassVisitor {
    private final AnnotationVisitor av = new AnnotationVisitor(327680){

        @Override
        public void visit(String name, Object value) {
            DependencyVisitor.this.visit(name, value);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            DependencyVisitor.this.visitEnum(name, desc, value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return DependencyVisitor.this.visitAnnotation(name, desc);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return DependencyVisitor.this.visitArray(name);
        }

        @Override
        public void visitEnd() {
            DependencyVisitor.this.visitEnd();
        }
    };
    private final SignatureVisitor sv = new SignatureVisitor(327680){

        @Override
        public void visitFormalTypeParameter(String name) {
            DependencyVisitor.this.visitFormalTypeParameter(name);
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return DependencyVisitor.this.visitClassBound();
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return DependencyVisitor.this.visitInterfaceBound();
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            return DependencyVisitor.this.visitSuperclass();
        }

        @Override
        public SignatureVisitor visitInterface() {
            return DependencyVisitor.this.visitInterface();
        }

        @Override
        public SignatureVisitor visitParameterType() {
            return DependencyVisitor.this.visitParameterType();
        }

        @Override
        public SignatureVisitor visitReturnType() {
            return DependencyVisitor.this.visitReturnType();
        }

        @Override
        public SignatureVisitor visitExceptionType() {
            return DependencyVisitor.this.visitExceptionType();
        }

        @Override
        public void visitBaseType(char descriptor) {
            DependencyVisitor.this.visitBaseType(descriptor);
        }

        @Override
        public void visitTypeVariable(String name) {
            DependencyVisitor.this.visitTypeVariable(name);
        }

        @Override
        public SignatureVisitor visitArrayType() {
            return DependencyVisitor.this.visitArrayType();
        }

        @Override
        public void visitClassType(String name) {
            DependencyVisitor.this.visitClassType(name);
        }

        @Override
        public void visitInnerClassType(String name) {
            DependencyVisitor.this.visitInnerClassType(name);
        }

        @Override
        public void visitTypeArgument() {
            DependencyVisitor.this.visitTypeArgument();
        }

        @Override
        public SignatureVisitor visitTypeArgument(char wildcard) {
            return DependencyVisitor.this.visitTypeArgument(wildcard);
        }

        @Override
        public void visitEnd() {
            DependencyVisitor.this.visitEnd();
        }
    };
    private final FieldVisitor fv = new FieldVisitor(327680){

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return DependencyVisitor.this.visitAnnotation(desc, visible);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return DependencyVisitor.this.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }

        @Override
        public void visitAttribute(Attribute attr) {
            DependencyVisitor.this.visitAttribute(attr);
        }

        @Override
        public void visitEnd() {
            DependencyVisitor.this.visitEnd();
        }
    };
    private final MethodVisitor mv = new MethodVisitor(327680){

        @Override
        public void visitParameter(String name, int access) {
            DependencyVisitor.this.visitParameter(name, access);
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return DependencyVisitor.this.visitAnnotationDefault();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return DependencyVisitor.this.visitAnnotation(desc, visible);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return DependencyVisitor.this.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return DependencyVisitor.this.visitParameterAnnotation(parameter, desc, visible);
        }

        @Override
        public void visitAttribute(Attribute attr) {
            DependencyVisitor.this.visitAttribute(attr);
        }

        @Override
        public void visitCode() {
            DependencyVisitor.this.visitCode();
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            DependencyVisitor.this.visitFrame(type, nLocal, local, nStack, stack);
        }

        @Override
        public void visitInsn(int opcode) {
            DependencyVisitor.this.visitInsn(opcode);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            DependencyVisitor.this.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            DependencyVisitor.this.visitVarInsn(opcode, var);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            DependencyVisitor.this.visitTypeInsn(opcode, type);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DependencyVisitor.this.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            DependencyVisitor.this.visitMethodInsn(opcode, owner, name, desc, false);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            DependencyVisitor.this.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            DependencyVisitor.this.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            DependencyVisitor.this.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitLabel(Label label) {
            DependencyVisitor.this.visitLabel(label);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            DependencyVisitor.this.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            DependencyVisitor.this.visitIincInsn(var, increment);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            DependencyVisitor.this.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            DependencyVisitor.this.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            DependencyVisitor.this.visitMultiANewArrayInsn(desc, dims);
        }

        @Override
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return DependencyVisitor.this.visitInsnAnnotation(typeRef, typePath, desc, visible);
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            DependencyVisitor.this.visitTryCatchBlock(start, end, handler, type);
        }

        @Override
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return DependencyVisitor.this.visitTryCatchAnnotation(typeRef, typePath, desc, visible);
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            DependencyVisitor.this.visitLocalVariable(name, desc, signature, start, end, index);
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            return DependencyVisitor.this.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            DependencyVisitor.this.visitLineNumber(line, start);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            DependencyVisitor.this.visitMaxs(maxStack, maxLocals);
        }

        @Override
        public void visitEnd() {
            DependencyVisitor.this.visitEnd();
        }
    };
    private Set packages = new LinkedHashSet();
    private Map groups = new LinkedHashMap();
    private Map current;
    private String tempLdc;
    private String ownerName;
    private Set innerClasses = new LinkedHashSet(4);
    private static final String CLASS_NAME = Class.class.getName();

    public DependencyVisitor() {
        super(327680);
    }

    private AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this.av;
    }

    private AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this.av;
    }

    private AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this.av;
    }

    private void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object[] bsmArgs) {
        for (Object o : bsmArgs) {
            if (!(o instanceof Type)) continue;
            this.addType((Type)o);
        }
    }

    private void visitParameter(String name, int access) {
        this.tempLdc = null;
    }

    public Map getGlobals() {
        return this.groups;
    }

    public Set getPackages() {
        return this.packages;
    }

    public Set getInnerClasses() {
        return this.innerClasses;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.tempLdc = null;
        this.ownerName = name;
        String p = this.getGroupKey(name);
        this.current = (Map)this.groups.get(p);
        if (this.current == null) {
            this.current = new LinkedHashMap();
            this.groups.put(p, this.current);
        }
        if (signature == null) {
            this.addName(superName);
            this.addNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this.av;
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.tempLdc = null;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.tempLdc = null;
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this.fv;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.tempLdc = null;
        if (signature == null) {
            this.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.addNames(exceptions);
        return this.mv;
    }

    @Override
    public void visitSource(String source, String debug) {
        this.tempLdc = null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.tempLdc = null;
        this.addName(name);
        this.addName(outerName);
        if (!this.ownerName.equals(name)) {
            this.innerClasses.add(name);
        }
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.tempLdc = null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this.av;
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.tempLdc = null;
        if (desc.charAt(0) == '[') {
            this.addDesc(desc);
        } else {
            this.addName(desc);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.tempLdc = null;
        this.addName(owner);
        this.addDesc(desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String returnType = Type.getReturnType(desc).getClassName();
        if (opcode == 184 && CLASS_NAME.equals(returnType) && this.tempLdc != null) {
            this.addName(this.tempLdc.replace('.', '/'));
        }
        this.tempLdc = null;
        this.addName(owner);
        this.addMethodDesc(desc);
    }

    public void visitLdcInsn(Object cst) {
        this.tempLdc = null;
        if (cst instanceof Type) {
            this.addType((Type)cst);
        } else if (cst instanceof String) {
            this.tempLdc = (String)cst;
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.tempLdc = null;
        this.addDesc(desc);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.tempLdc = null;
        this.addTypeSignature(signature);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.tempLdc = null;
        return this.av;
    }

    public void visitCode() {
        this.tempLdc = null;
    }

    public void visitFrame(int i, int i1, Object[] objects, int i2, Object[] objects1) {
        this.tempLdc = null;
    }

    public void visitInsn(int opcode) {
        this.tempLdc = null;
    }

    public void visitIntInsn(int opcode, int operand) {
        this.tempLdc = null;
    }

    public void visitVarInsn(int opcode, int var) {
        this.tempLdc = null;
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.tempLdc = null;
    }

    public void visitLabel(Label label) {
        this.tempLdc = null;
    }

    public void visitIincInsn(int var, int increment) {
        this.tempLdc = null;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.tempLdc = null;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.tempLdc = null;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.tempLdc = null;
        this.addName(type);
    }

    public void visitLineNumber(int line, Label start) {
        this.tempLdc = null;
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.tempLdc = null;
    }

    public void visit(String name, Object value) {
        this.tempLdc = null;
        if (value instanceof Type) {
            this.addType((Type)value);
        }
    }

    public void visitEnum(String name, String desc, String value) {
        this.tempLdc = null;
        this.addDesc(desc);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.tempLdc = null;
        this.addDesc(desc);
        return this.av;
    }

    public AnnotationVisitor visitArray(String name) {
        this.tempLdc = null;
        return this.av;
    }

    public void visitFormalTypeParameter(String name) {
        this.tempLdc = null;
    }

    public SignatureVisitor visitClassBound() {
        this.tempLdc = null;
        return this.sv;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.tempLdc = null;
        return this.sv;
    }

    public SignatureVisitor visitSuperclass() {
        this.tempLdc = null;
        return this.sv;
    }

    public SignatureVisitor visitInterface() {
        this.tempLdc = null;
        return this.sv;
    }

    public SignatureVisitor visitParameterType() {
        this.tempLdc = null;
        return this.sv;
    }

    public SignatureVisitor visitReturnType() {
        this.tempLdc = null;
        return this.sv;
    }

    public SignatureVisitor visitExceptionType() {
        this.tempLdc = null;
        return this.sv;
    }

    public void visitBaseType(char descriptor) {
        this.tempLdc = null;
    }

    public void visitTypeVariable(String name) {
        this.tempLdc = null;
    }

    public SignatureVisitor visitArrayType() {
        this.tempLdc = null;
        return this.sv;
    }

    public void visitClassType(String name) {
        this.tempLdc = null;
        this.addName(name);
    }

    public void visitInnerClassType(String name) {
        this.tempLdc = null;
        this.addName(name);
    }

    public void visitTypeArgument() {
        this.tempLdc = null;
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.tempLdc = null;
        return this.sv;
    }

    @Override
    public void visitEnd() {
        this.tempLdc = null;
    }

    private String getGroupKey(String name) {
        int n = name.lastIndexOf(47);
        if (n > -1) {
            name = name.substring(0, n);
        }
        this.packages.add(name);
        return name;
    }

    private void addName(String name) {
        if (name == null) {
            return;
        }
        String p = this.getGroupKey(name);
        if (this.current.containsKey(p)) {
            this.current.put(p, new Integer((Integer)this.current.get(p) + 1));
        } else {
            this.current.put(p, new Integer(1));
        }
    }

    private void addNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.addName(names[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType(desc));
    }

    private void addMethodDesc(String desc) {
        this.addType(Type.getReturnType(desc));
        Type[] types = Type.getArgumentTypes(desc);
        for (int i = 0; i < types.length; ++i) {
            this.addType(types[i]);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName().replace('.', '/'));
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept(this.sv);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType(this.sv);
        }
    }
}

