/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.support;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.gemini.blueprint.test.internal.OsgiJUnitTest;
import org.osgi.framework.BundleContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class OsgiJUnitTestAdapter
implements OsgiJUnitTest {
    private final TestCase target;
    private final Method injectBundleContext;
    private final Method runTest;
    private final Method setUp;
    private final Method tearDown;

    public OsgiJUnitTestAdapter(TestCase target) {
        Assert.notNull((Object)target, (String)"the adapter can be used only with a non-null test");
        this.target = target;
        try {
            this.injectBundleContext = ReflectionUtils.findMethod(target.getClass(), (String)"injectBundleContext", (Class[])new Class[]{BundleContext.class});
            ReflectionUtils.makeAccessible((Method)this.injectBundleContext);
            this.runTest = ReflectionUtils.findMethod(target.getClass(), (String)"osgiRunTest");
            ReflectionUtils.makeAccessible((Method)this.runTest);
            this.setUp = ReflectionUtils.findMethod(target.getClass(), (String)"osgiSetUp");
            ReflectionUtils.makeAccessible((Method)this.setUp);
            this.tearDown = ReflectionUtils.findMethod(target.getClass(), (String)"osgiTearDown");
            ReflectionUtils.makeAccessible((Method)this.tearDown);
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot determine JUnit hooks; is this test extending Spring-DM test framework?", ex);
        }
    }

    @Override
    public void injectBundleContext(BundleContext bundleContext) {
        ReflectionUtils.invokeMethod((Method)this.injectBundleContext, (Object)this.target, (Object[])new Object[]{bundleContext});
    }

    @Override
    public void osgiRunTest() throws Throwable {
        ReflectionUtils.invokeMethod((Method)this.runTest, (Object)this.target);
    }

    @Override
    public void osgiSetUp() throws Exception {
        ReflectionUtils.invokeMethod((Method)this.setUp, (Object)this.target);
    }

    @Override
    public void osgiTearDown() throws Exception {
        ReflectionUtils.invokeMethod((Method)this.tearDown, (Object)this.target);
    }

    @Override
    public TestCase getTestCase() {
        return this.target;
    }
}

