/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test.internal.holder;

import java.lang.reflect.Method;
import org.eclipse.gemini.blueprint.test.internal.holder.OsgiTestInfoHolder;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ReflectionOsgiHolder
extends OsgiTestInfoHolder {
    private final Object instance;
    private final Method GET_TEST_BUNDLE_ID;
    private final Method GET_TEST_CLASS_NAME;
    private final Method GET_TEST_METHOD_NAME;
    private final Method ADD_TEST_ERROR;
    private final Method ADD_TEST_FAILURE;

    ReflectionOsgiHolder(Object twinInstance) {
        Assert.notNull((Object)twinInstance);
        this.instance = twinInstance;
        Class<?> clazz = this.instance.getClass();
        this.GET_TEST_BUNDLE_ID = ReflectionUtils.findMethod(clazz, (String)"getTestBundleId");
        this.GET_TEST_CLASS_NAME = ReflectionUtils.findMethod(clazz, (String)"getTestClassName");
        this.GET_TEST_METHOD_NAME = ReflectionUtils.findMethod(clazz, (String)"getTestMethodName");
        this.ADD_TEST_ERROR = ReflectionUtils.findMethod(clazz, (String)"addTestError", (Class[])new Class[]{Throwable.class});
        this.ADD_TEST_FAILURE = ReflectionUtils.findMethod(clazz, (String)"addTestFailure", (Class[])new Class[]{Throwable.class});
    }

    @Override
    public Long getTestBundleId() {
        return (Long)ReflectionUtils.invokeMethod((Method)this.GET_TEST_BUNDLE_ID, (Object)this.instance);
    }

    @Override
    public String getTestClassName() {
        return (String)ReflectionUtils.invokeMethod((Method)this.GET_TEST_CLASS_NAME, (Object)this.instance);
    }

    @Override
    public String getTestMethodName() {
        return (String)ReflectionUtils.invokeMethod((Method)this.GET_TEST_METHOD_NAME, (Object)this.instance);
    }

    @Override
    public void addTestError(Throwable testProblem) {
        ReflectionUtils.invokeMethod((Method)this.ADD_TEST_ERROR, (Object)this.instance, (Object[])new Object[]{testProblem});
    }

    @Override
    public void addTestFailure(Throwable testProblem) {
        ReflectionUtils.invokeMethod((Method)this.ADD_TEST_FAILURE, (Object)this.instance, (Object[])new Object[]{testProblem});
    }
}

