/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.gemini.blueprint.test.AbstractOsgiTests;
import org.eclipse.gemini.blueprint.test.platform.EquinoxPlatform;
import org.eclipse.gemini.blueprint.test.platform.OsgiPlatform;
import org.eclipse.gemini.blueprint.test.platform.Platforms;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractConfigurableOsgiTests
extends AbstractOsgiTests {
    public static final String OSGI_FRAMEWORK_SELECTOR = "org.eclipse.gemini.blueprint.test.framework";

    public AbstractConfigurableOsgiTests() {
    }

    public AbstractConfigurableOsgiTests(String name) {
        super(name);
    }

    @Override
    protected OsgiPlatform createPlatform() {
        boolean trace = this.logger.isTraceEnabled();
        String platformClassName = this.getPlatformName();
        OsgiPlatform platform = null;
        ClassLoader currentCL = ((Object)((Object)this)).getClass().getClassLoader();
        if (StringUtils.hasText((String)platformClassName)) {
            if (ClassUtils.isPresent((String)platformClassName, (ClassLoader)currentCL)) {
                Class platformClass = ClassUtils.resolveClassName((String)platformClassName, (ClassLoader)currentCL);
                if (OsgiPlatform.class.isAssignableFrom(platformClass)) {
                    if (trace) {
                        this.logger.trace((Object)"Instantiating platform wrapper...");
                    }
                    try {
                        platform = (OsgiPlatform)platformClass.newInstance();
                    }
                    catch (Exception ex) {
                        this.logger.warn((Object)("cannot instantiate class [" + platformClass + "]; using default"));
                    }
                } else {
                    this.logger.warn((Object)("Class [" + platformClass + "] does not implement " + OsgiPlatform.class.getName() + " interface; falling back to defaults"));
                }
            } else {
                this.logger.warn((Object)("OSGi platform starter [" + platformClassName + "] not found; using default"));
            }
        } else {
            this.logger.trace((Object)"No platform specified; using default");
        }
        if (platform == null) {
            platform = new EquinoxPlatform();
        }
        Properties config = platform.getConfigurationProperties();
        config.setProperty("org.osgi.framework.bootdelegation", this.getBootDelegationPackageString());
        return platform;
    }

    protected String getPlatformName() {
        String systemProperty = System.getProperty(OSGI_FRAMEWORK_SELECTOR);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("System property [org.eclipse.gemini.blueprint.test.framework] has value=" + systemProperty));
        }
        return !StringUtils.hasText((String)systemProperty) ? Platforms.EQUINOX : systemProperty;
    }

    private String getBootDelegationPackageString() {
        StringBuilder buf = new StringBuilder();
        Iterator<String> iter = this.getBootDelegationPackages().iterator();
        while (iter.hasNext()) {
            buf.append(iter.next().trim());
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    protected List<String> getBootDelegationPackages() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("javax.*");
        defaults.add("javax.sql.*");
        defaults.add("javax.transaction.*");
        defaults.add("javax.activation.*");
        defaults.add("org.w3c.*");
        defaults.add("org.xml.*");
        defaults.add("sun.*");
        defaults.add("com.sun.*");
        defaults.add("org.objectweb.*");
        defaults.add("org.apache.xerces.jaxp.*");
        return defaults;
    }
}

