/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.io.modbus.BitsModbusMessage;
import net.solarnetwork.io.modbus.ModbusBlockType;
import net.solarnetwork.io.modbus.ModbusClient;
import net.solarnetwork.io.modbus.ModbusClientConfig;
import net.solarnetwork.io.modbus.ModbusClientConnectionObserver;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.RegistersModbusMessage;
import net.solarnetwork.io.modbus.netty.handler.NettyModbusClient;
import net.solarnetwork.io.modbus.rtu.RtuModbusClientConfig;
import net.solarnetwork.io.modbus.rtu.jsc.JscSerialPortProvider;
import net.solarnetwork.io.modbus.rtu.netty.NettyRtuModbusClientConfig;
import net.solarnetwork.io.modbus.rtu.netty.RtuNettyModbusClient;
import net.solarnetwork.io.modbus.serial.BasicSerialParameters;
import net.solarnetwork.io.modbus.serial.SerialParameters;
import net.solarnetwork.io.modbus.serial.SerialParity;
import net.solarnetwork.io.modbus.serial.SerialPortProvider;
import net.solarnetwork.io.modbus.serial.SerialStopBits;
import net.solarnetwork.io.modbus.tcp.TcpModbusClientConfig;
import net.solarnetwork.io.modbus.tcp.netty.NettyTcpModbusClientConfig;
import net.solarnetwork.io.modbus.tcp.netty.TcpNettyModbusClient;

public class ModbusShell
implements ModbusClientConnectionObserver {
    private final NettyModbusClient<?> client;
    private final BufferedReader in;
    private final PrintWriter out;
    private static final Pattern SHELL_LINE_SPLIT_REGEX = Pattern.compile("\\s+");
    private static final Pattern BITS_REGEX = Pattern.compile("(\\d)([EON])(\\d)", 2);

    public ModbusShell(NettyModbusClient<?> client, BufferedReader in, PrintWriter out) {
        this.client = client;
        this.in = in;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.client.start().get();
            Thread.sleep(200L);
            block24: while (this.client.isConnected()) {
                String cmd;
                this.out.print("> ");
                this.out.flush();
                String line = this.in.readLine();
                if (line == null) {
                    return;
                }
                if ((line = line.trim()).isEmpty()) continue;
                String[] args = SHELL_LINE_SPLIT_REGEX.split(line);
                switch (cmd = args[0].toLowerCase()) {
                    case "e": 
                    case "q": 
                    case "exit": 
                    case "quit": {
                        return;
                    }
                    case "r": 
                    case "read": {
                        this.read(args);
                        continue block24;
                    }
                    case "w": 
                    case "write": {
                        this.write(args);
                        continue block24;
                    }
                }
                this.out.println(String.format("Unknown command [%s]", cmd));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable t = e.getCause();
            this.out.printf("Error opening connection to [%s]: %s", this.client.getClientConfig(), t.getMessage());
        }
        catch (IOException e) {
            this.out.println("Communication error: " + e.toString());
        }
        finally {
            this.client.stop();
        }
    }

    public void connectionOpened(ModbusClient client, ModbusClientConfig config) {
        this.out.printf("Connected to %s\n", config);
    }

    public void connectionClosed(ModbusClient client, ModbusClientConfig config, Throwable exception, boolean willReconnect) {
        this.out.printf("Connection closed to %s\n", config);
        System.exit(0);
    }

    private void read(String ... args) {
        if (args.length < 2) {
            this.out.println("Must provide register type to read from (coil, discrete, input, holding).");
            return;
        }
        String type = args[1].toLowerCase();
        ModbusBlockType blockType = null;
        switch (type) {
            case "c": 
            case "coil": 
            case "coils": {
                blockType = ModbusBlockType.Coil;
                break;
            }
            case "d": 
            case "discrete": 
            case "discretes": {
                blockType = ModbusBlockType.Discrete;
                break;
            }
            case "i": 
            case "input": 
            case "inputs": {
                blockType = ModbusBlockType.Input;
                break;
            }
            case "h": 
            case "holding": 
            case "holdings": {
                blockType = ModbusBlockType.Holding;
                break;
            }
            default: {
                this.out.printf("Unsupported block type [%s]; must be one of coil, discrete, input, or holding.\n", type);
                return;
            }
        }
        boolean oneBased = false;
        int addrBase = 10;
        int unitId = -1;
        int addr = 0;
        int count = 1;
        int len = args.length;
        for (int i = 2; i < len; ++i) {
            try {
                switch (args[i]) {
                    case "-1": {
                        oneBased = true;
                        break;
                    }
                    case "-a": 
                    case "--unit": {
                        unitId = Integer.parseInt(args[++i]);
                        break;
                    }
                    case "-r": 
                    case "--register": {
                        addr = Integer.parseInt(args[++i]);
                        break;
                    }
                    case "-r:hex": 
                    case "--register:hex": {
                        addr = Integer.parseInt(args[++i], 16);
                        addrBase = 16;
                        break;
                    }
                    case "-c": 
                    case "--count": {
                        count = Integer.parseInt(args[++i]);
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.out.printf("Missing value for %s argument.\n", args[i - 1]);
                return;
            }
            catch (NumberFormatException e) {
                this.out.printf("Expected a number value for %s argument.\n", args[i - 1]);
                return;
            }
            catch (IllegalArgumentException e) {
                this.out.printf("Invalid value for %s argument: %s\n", args[i - 1], e.getMessage());
                return;
            }
        }
        if (unitId < 0) {
            this.out.println("Must provide unit ID (--unit).");
            return;
        }
        if (addr < oneBased) {
            this.out.printf("Invalid starting register address (--register): minimum is %d", oneBased ? 1 : 0);
            return;
        }
        if (count < 1) {
            this.out.println("Must provide count of registers to read (--count).");
            return;
        }
        Future f = null;
        switch (blockType) {
            case Coil: 
            case Discrete: {
                f = this.client.sendAsync((ModbusMessage)net.solarnetwork.io.modbus.netty.msg.BitsModbusMessage.readBitsRequest((ModbusBlockType)blockType, (int)unitId, (int)(oneBased ? addr - 1 : addr), (int)count));
                break;
            }
            case Input: 
            case Holding: {
                f = this.client.sendAsync((ModbusMessage)net.solarnetwork.io.modbus.netty.msg.RegistersModbusMessage.readRegistersRequest((ModbusBlockType)blockType, (int)unitId, (int)(oneBased ? addr - 1 : addr), (int)count));
                break;
            }
        }
        if (f == null) {
            return;
        }
        int addrEnd = addr + count - 1;
        int addrWidth = Integer.toString(addrEnd, addrBase).length();
        try {
            ModbusMessage res = (ModbusMessage)f.get(15L, TimeUnit.SECONDS);
            switch (blockType) {
                case Coil: 
                case Discrete: {
                    BitsModbusMessage bits = (BitsModbusMessage)res.unwrap(BitsModbusMessage.class);
                    if (bits != null) {
                        String tmpl = "[" + (addrBase == 16 ? "0x" : "") + "%0" + addrWidth + (addrBase == 16 ? "X" : "d") + "]: %d\n";
                        for (int i = 0; i < count; ++i) {
                            this.out.printf(tmpl, addr + i, bits.isBitEnabled(i) ? 1 : 0);
                        }
                        break;
                    }
                    this.out.printf("Unexpected response: %s\n", res);
                    break;
                }
                case Input: 
                case Holding: {
                    RegistersModbusMessage regs = (RegistersModbusMessage)res.unwrap(RegistersModbusMessage.class);
                    if (regs != null) {
                        String tmpl = "[" + (addrBase == 16 ? "0x" : "") + "%0" + addrWidth + (addrBase == 16 ? "X" : "d") + "]: 0x%04X\n";
                        short[] data = regs.dataDecode();
                        int len2 = data.length;
                        for (int i = 0; i < len2; ++i) {
                            this.out.printf(tmpl, addr + i, data[i]);
                        }
                        break;
                    }
                    this.out.printf("Unexpected response: %s\n", res);
                    break;
                }
            }
        }
        catch (TimeoutException e) {
            this.out.println("Timeout waiting for response.");
        }
        catch (InterruptedException e) {
            this.out.println("Interrupted waiting for response.");
        }
        catch (ExecutionException e) {
            this.out.println("Error: " + e.getCause().toString());
        }
    }

    private void write(String ... args) {
        if (args.length < 2) {
            this.out.println("Must provide register type to write to (coil, discrete, input, holding).");
            return;
        }
        String type = args[1].toLowerCase();
        ModbusBlockType blockType = null;
        switch (type) {
            case "c": 
            case "coil": 
            case "coils": {
                blockType = ModbusBlockType.Coil;
                break;
            }
            case "h": 
            case "holding": 
            case "holdings": {
                blockType = ModbusBlockType.Holding;
                break;
            }
            default: {
                this.out.printf("Unsupported block type [%s]; must be one of coil or holding.\n", type);
                return;
            }
        }
        boolean oneBased = false;
        int addrBase = 10;
        int unitId = -1;
        int addr = 0;
        ArrayList<Short> values = new ArrayList<Short>(8);
        int len = args.length;
        for (int i = 2; i < len; ++i) {
            try {
                switch (args[i]) {
                    case "-1": {
                        oneBased = true;
                        break;
                    }
                    case "-a": 
                    case "--unit": {
                        unitId = Integer.parseInt(args[++i]);
                        break;
                    }
                    case "-r": 
                    case "--register": {
                        addr = Integer.parseInt(args[++i]);
                        break;
                    }
                    case "-r:hex": 
                    case "--register:hex": {
                        addr = Integer.parseInt(args[++i], 16);
                        addrBase = 16;
                        break;
                    }
                    default: {
                        try {
                            if (args[i].toLowerCase().startsWith("0x")) {
                                values.add(new BigInteger(args[i].substring(2), 16).shortValue());
                                break;
                            }
                            values.add(Integer.valueOf(args[i]).shortValue());
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.out.printf("Invalid write value: [%s]\n", args[i]);
                            return;
                        }
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.out.printf("Missing value for %s argument.\n", args[i - 1]);
                return;
            }
            catch (NumberFormatException e) {
                this.out.printf("Expected a number value for %s argument.\n", args[i - 1]);
                return;
            }
            catch (IllegalArgumentException e) {
                this.out.printf("Invalid value for %s argument: %s\n", args[i - 1], e.getMessage());
                return;
            }
        }
        if (unitId < 0) {
            this.out.println("Must provide unit ID (--unit).");
            return;
        }
        if (addr < oneBased) {
            this.out.printf("Invalid starting register address (--register): minimum is %d", oneBased ? 1 : 0);
            return;
        }
        if (values.isEmpty()) {
            this.out.println("Must provide values to write.");
            return;
        }
        int count = values.size();
        Future f = null;
        net.solarnetwork.io.modbus.netty.msg.BitsModbusMessage req = null;
        switch (blockType) {
            case Coil: {
                int i;
                BigInteger bits = BigInteger.ZERO;
                for (i = 0; i < count; ++i) {
                    if ((Short)values.get(i) != 1) continue;
                    bits = bits.setBit(i);
                }
                req = count > 1 ? net.solarnetwork.io.modbus.netty.msg.BitsModbusMessage.writeCoilsRequest((int)unitId, (int)(oneBased ? addr - 1 : addr), (int)count, (BigInteger)bits) : net.solarnetwork.io.modbus.netty.msg.BitsModbusMessage.writeCoilRequest((int)unitId, (int)addr, (boolean)bits.testBit(0));
                break;
            }
            case Holding: {
                int i;
                short[] dataValues = new short[count];
                for (i = 0; i < count; ++i) {
                    dataValues[i] = (Short)values.get(i);
                }
                req = count > 1 ? net.solarnetwork.io.modbus.netty.msg.RegistersModbusMessage.writeHoldingsRequest((int)unitId, (int)(oneBased ? addr - 1 : addr), (short[])dataValues) : net.solarnetwork.io.modbus.netty.msg.RegistersModbusMessage.writeHoldingRequest((int)unitId, (int)addr, (int)dataValues[0]);
                break;
            }
        }
        if (req != null) {
            f = this.client.sendAsync(req);
        }
        if (f == null) {
            return;
        }
        int addrEnd = addr + count - 1;
        int addrWidth = Integer.toString(addrEnd, addrBase).length();
        try {
            ModbusMessage res = (ModbusMessage)f.get(15L, TimeUnit.SECONDS);
            switch (blockType) {
                case Coil: {
                    BitsModbusMessage bits = (BitsModbusMessage)res.unwrap(BitsModbusMessage.class);
                    if (bits != null) {
                        BigInteger data = bits.getBits();
                        if (data != null) {
                            String tmpl = "[" + (addrBase == 16 ? "0x" : "") + "%0" + addrWidth + (addrBase == 16 ? "X" : "d") + "]: %d\n";
                            for (int i = 0; i < count; ++i) {
                                this.out.printf(tmpl, addr + i, bits.isBitEnabled(i) ? 1 : 0);
                            }
                            break;
                        }
                        this.out.println("Write accepted.");
                        break;
                    }
                    this.out.printf("Unexpected response: %s\n", res);
                    break;
                }
                case Holding: {
                    RegistersModbusMessage regs = (RegistersModbusMessage)res.unwrap(RegistersModbusMessage.class);
                    if (regs != null) {
                        short[] data = regs.dataDecode();
                        if (data != null) {
                            String tmpl = "[" + (addrBase == 16 ? "0x" : "") + "%0" + addrWidth + (addrBase == 16 ? "X" : "d") + "]: 0x%04X\n";
                            int len2 = data.length;
                            for (int i = 0; i < len2; ++i) {
                                this.out.printf(tmpl, addr + i, data[i]);
                            }
                            break;
                        }
                        this.out.println("Write accepted.");
                        break;
                    }
                    this.out.printf("Unexpected response: %s\n", res);
                    break;
                }
            }
        }
        catch (TimeoutException e) {
            this.out.println("Timeout waiting for response.");
        }
        catch (InterruptedException e) {
            this.out.println("Interrupted waiting for response.");
        }
        catch (ExecutionException e) {
            this.out.println("Error: " + e.getCause().toString());
        }
    }

    public static void main(String ... args) {
        if (args == null || args.length < 1) {
            System.err.println("Must provide the serial port name -port argument.");
            return;
        }
        String deviceName = null;
        String hostName = null;
        int hostPort = 502;
        BasicSerialParameters params = new BasicSerialParameters();
        boolean wireLogging = false;
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            try {
                switch (args[i]) {
                    case "-dev": 
                    case "--device": {
                        deviceName = args[++i];
                        break;
                    }
                    case "-b": 
                    case "--baud": {
                        params.setBaudRate(Integer.parseInt(args[++i]));
                        break;
                    }
                    case "-d": 
                    case "--data": {
                        params.setDataBits(Integer.parseInt(args[++i]));
                        break;
                    }
                    case "-s": 
                    case "--stop": {
                        params.setStopBits(SerialStopBits.forCode((int)Integer.parseInt(args[++i])));
                        break;
                    }
                    case "-P": 
                    case "--parity": {
                        params.setParity(SerialParity.forCode((int)Integer.parseInt(args[++i])));
                        break;
                    }
                    case "--bits": {
                        Matcher m = BITS_REGEX.matcher(args[++i]);
                        if (!m.matches()) {
                            throw new IllegalArgumentException("Must match DPS for data bits, parity, stop bits, for example 8N1");
                        }
                        params.setDataBits(Integer.parseInt(m.group(1)));
                        params.setParity(SerialParity.forAbbreviation((String)m.group(2)));
                        params.setStopBits(SerialStopBits.forCode((int)Integer.parseInt(m.group(3))));
                        break;
                    }
                    case "-h": 
                    case "--host": {
                        hostName = args[++i];
                        break;
                    }
                    case "-p": 
                    case "--port": {
                        hostPort = Integer.parseInt(args[++i]);
                        break;
                    }
                    case "--debug": {
                        wireLogging = true;
                    }
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.printf("Missing value for %s argument.\n", args[i - 1]);
                System.exit(1);
                continue;
            }
            catch (NumberFormatException e) {
                System.err.printf("Expected a number value for %s argument.\n", args[i - 1]);
                System.exit(1);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.printf("Invalid value for %s argument: %s\n", args[i - 1], e.getMessage());
                System.exit(1);
            }
        }
        TcpNettyModbusClient client = null;
        if (deviceName != null && !deviceName.trim().isEmpty()) {
            NettyRtuModbusClientConfig config = new NettyRtuModbusClientConfig(deviceName, (SerialParameters)params);
            config.setAutoReconnect(false);
            client = new RtuNettyModbusClient((RtuModbusClientConfig)config, (SerialPortProvider)new JscSerialPortProvider());
        } else if (hostName != null && !hostName.trim().isEmpty()) {
            NettyTcpModbusClientConfig config = new NettyTcpModbusClientConfig(hostName, hostPort);
            config.setAutoReconnect(false);
            client = new TcpNettyModbusClient((TcpModbusClientConfig)config);
        }
        if (client == null) {
            System.err.println("Must provide either --device or --host argument for the Modbus device to connect to.");
            System.exit(1);
        }
        ModbusShell shell = new ModbusShell((NettyModbusClient<?>)client, new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.out, true));
        client.setConnectionObserver((ModbusClientConnectionObserver)shell);
        client.setWireLogging(wireLogging);
        shell.start();
    }
}

