/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.rtu.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.solarnetwork.io.modbus.ModbusClientConfig;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.netty.handler.NettyModbusClient;
import net.solarnetwork.io.modbus.netty.serial.SerialAddress;
import net.solarnetwork.io.modbus.netty.serial.SerialPortChannel;
import net.solarnetwork.io.modbus.rtu.RtuModbusClientConfig;
import net.solarnetwork.io.modbus.rtu.netty.RtuModbusMessageDecoder;
import net.solarnetwork.io.modbus.rtu.netty.RtuModbusMessageEncoder;
import net.solarnetwork.io.modbus.serial.SerialPortProvider;

public class RtuNettyModbusClient
extends NettyModbusClient<RtuModbusClientConfig>
implements ChannelFactory<SerialPortChannel> {
    private final boolean privateEventLoopGroup;
    private final SerialPortProvider serialPortProvider;
    private EventLoopGroup eventLoopGroup;
    private CompletableFuture<?> eventLoopGroupStopFuture;

    public RtuNettyModbusClient(RtuModbusClientConfig clientConfig, SerialPortProvider serialPortProvider) {
        this(clientConfig, null, new ConcurrentHashMap<ModbusMessage, NettyModbusClient.PendingMessage>(8, 0.9f, 2), null, serialPortProvider);
    }

    public RtuNettyModbusClient(RtuModbusClientConfig clientConfig, EventLoopGroup eventLoopGroup, SerialPortProvider serialPortProvider) {
        this(clientConfig, null, new ConcurrentHashMap<ModbusMessage, NettyModbusClient.PendingMessage>(8, 0.9f, 2), eventLoopGroup, serialPortProvider);
    }

    public RtuNettyModbusClient(RtuModbusClientConfig clientConfig, ScheduledExecutorService scheduler, EventLoopGroup eventLoopGroup, SerialPortProvider serialPortProvider) {
        this(clientConfig, scheduler, new ConcurrentHashMap<ModbusMessage, NettyModbusClient.PendingMessage>(8, 0.9f, 2), eventLoopGroup, serialPortProvider);
    }

    public RtuNettyModbusClient(RtuModbusClientConfig clientConfig, ScheduledExecutorService scheduler, ConcurrentMap<ModbusMessage, NettyModbusClient.PendingMessage> pending, EventLoopGroup eventLoopGroup, SerialPortProvider serialPortProvider) {
        super((ModbusClientConfig)clientConfig, scheduler, pending);
        if (eventLoopGroup == null) {
            eventLoopGroup = RtuNettyModbusClient.defaultEventLoopGroup();
            this.privateEventLoopGroup = true;
        } else {
            this.privateEventLoopGroup = false;
        }
        this.eventLoopGroup = eventLoopGroup;
        if (serialPortProvider == null) {
            throw new IllegalArgumentException("The serialPortProvider argument must not be null.");
        }
        this.serialPortProvider = serialPortProvider;
    }

    private static EventLoopGroup defaultEventLoopGroup() {
        return new OioEventLoopGroup();
    }

    public SerialPortChannel newChannel() {
        SerialPortChannel channel = new SerialPortChannel(this.serialPortProvider);
        channel.config().setSerialParameters(((RtuModbusClientConfig)this.clientConfig).getSerialParameters());
        return channel;
    }

    protected ChannelFuture connect() throws IOException {
        this.eventLoopGroupStopFuture = null;
        String name = ((RtuModbusClientConfig)this.clientConfig).getName();
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("No serial device name configured, cannot connect.");
        }
        if (this.eventLoopGroup.isShuttingDown()) {
            if (this.privateEventLoopGroup) {
                this.eventLoopGroup = RtuNettyModbusClient.defaultEventLoopGroup();
            } else {
                throw new IOException("External EventLoopGroup is stopped.");
            }
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channelFactory((ChannelFactory)this)).remoteAddress((SocketAddress)new SerialAddress(((RtuModbusClientConfig)this.clientConfig).getName())).handler((ChannelHandler)new HandlerInitializer());
        return bootstrap.connect();
    }

    public synchronized CompletableFuture<?> stop() {
        CompletableFuture f = super.stop();
        if (!this.privateEventLoopGroup) {
            return f;
        }
        if (this.eventLoopGroupStopFuture == null) {
            this.eventLoopGroupStopFuture = new CompletableFuture();
            try {
                this.eventLoopGroup.shutdownGracefully().get(10L, TimeUnit.SECONDS);
                this.eventLoopGroupStopFuture.complete(null);
            }
            catch (TimeoutException e) {
                this.log.warn("Timeout waiting for {} EventLoopGroup to shutdown", (Object)((RtuModbusClientConfig)this.clientConfig).getDescription());
                this.eventLoopGroupStopFuture.completeExceptionally(e);
            }
            catch (Exception e) {
                this.log.warn("{} waiting for {} EventLoopGroup to shutdown", (Object)e.getClass().getSimpleName(), (Object)((RtuModbusClientConfig)this.clientConfig).getDescription());
                this.eventLoopGroupStopFuture.completeExceptionally(e);
            }
        }
        return f.thenCompose(s -> this.eventLoopGroupStopFuture);
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("modbusMessageEncoder", (ChannelHandler)new RtuModbusMessageEncoder());
        pipeline.addLast("modbusMessageDecoder", (ChannelHandler)new RtuModbusMessageDecoder(true));
        super.initChannel(channel);
    }

    private final class HandlerInitializer
    extends ChannelInitializer<SerialPortChannel> {
        private HandlerInitializer() {
        }

        protected void initChannel(SerialPortChannel ch) throws Exception {
            RtuNettyModbusClient.this.initChannel((Channel)ch);
        }
    }
}

