/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.rtu.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import net.solarnetwork.io.modbus.AddressedModbusMessage;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.netty.handler.NettyModbusClient;
import net.solarnetwork.io.modbus.netty.msg.ModbusMessageUtils;
import net.solarnetwork.io.modbus.netty.msg.SimpleModbusMessageReply;
import net.solarnetwork.io.modbus.rtu.netty.RtuModbusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtuModbusMessageDecoder
extends ReplayingDecoder<DecoderState> {
    private static final Logger log = LoggerFactory.getLogger(RtuModbusMessageDecoder.class);
    public static final int FIXED_HEADER_LENGTH = 7;
    private final boolean controller;
    private short unitId;

    public RtuModbusMessageDecoder(boolean controller) {
        super((Object)DecoderState.READ_FIXED_HEADER);
        this.controller = controller;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case READ_FIXED_HEADER: {
                this.readFixedHeader(ctx, in);
                break;
            }
            case READ_PAYLOAD: {
                this.readPayload(ctx, in, out);
                break;
            }
            case BAD_DATA: {
                in.skipBytes(in.readableBytes());
                this.checkpoint((Object)DecoderState.READ_FIXED_HEADER);
            }
        }
    }

    private void readFixedHeader(ChannelHandlerContext ctx, ByteBuf in) {
        this.unitId = in.readUnsignedByte();
        this.checkpoint((Object)DecoderState.READ_PAYLOAD);
    }

    private void readPayload(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ModbusMessage msg = null;
        ModbusMessage req = null;
        AddressedModbusMessage reqAddr = null;
        if (this.controller) {
            int len = ModbusMessageUtils.discoverResponsePayloadLength((ByteBuf)in);
            if (len < 1) {
                this.checkpoint((Object)DecoderState.BAD_DATA);
                return;
            }
            req = (ModbusMessage)ctx.channel().attr(NettyModbusClient.LAST_ENCODED_MESSAGE).get();
            reqAddr = req instanceof AddressedModbusMessage ? (AddressedModbusMessage)req : null;
            msg = ModbusMessageUtils.decodeResponsePayload((int)this.unitId, (int)(reqAddr != null ? reqAddr.getAddress() : 0), (int)(reqAddr != null ? reqAddr.getCount() : 0), (ByteBuf)in);
        } else {
            msg = ModbusMessageUtils.decodeRequestPayload((int)this.unitId, (int)0, (int)0, (ByteBuf)in);
        }
        if (msg != null) {
            short computedCrc;
            short crc = in.readShortLE();
            if (crc != (computedCrc = RtuModbusMessage.computeCrc(this.unitId, msg))) {
                log.warn("CRC mismatch: frame value {} but computed value {} from {}", new Object[]{Short.toUnsignedInt(crc), Short.toUnsignedInt(computedCrc), msg});
            }
            if (req != null) {
                msg = new SimpleModbusMessageReply(req, (ModbusMessage)new RtuModbusMessage(msg, crc));
                ctx.channel().attr(NettyModbusClient.LAST_ENCODED_MESSAGE).compareAndSet((Object)req, null);
            } else {
                msg = new RtuModbusMessage(msg, crc);
            }
            out.add(msg);
        }
        this.checkpoint((Object)DecoderState.READ_FIXED_HEADER);
    }

    static enum DecoderState {
        READ_FIXED_HEADER,
        READ_PAYLOAD,
        BAD_DATA;

    }
}

