/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.rtu.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.solarnetwork.io.modbus.ModbusByteUtils;
import net.solarnetwork.io.modbus.ModbusError;
import net.solarnetwork.io.modbus.ModbusFunction;
import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.ModbusValidationException;
import net.solarnetwork.io.modbus.netty.msg.ModbusPayloadEncoder;

public class RtuModbusMessage
implements net.solarnetwork.io.modbus.rtu.RtuModbusMessage,
ModbusPayloadEncoder {
    private final long timestamp;
    private final short crc;
    private final ModbusMessage body;

    public RtuModbusMessage(int unitId, ModbusMessage body) {
        this(System.currentTimeMillis(), body, RtuModbusMessage.computeCrc(unitId, body));
    }

    public RtuModbusMessage(long timestamp, int unitId, ModbusMessage body) {
        this(timestamp, body, RtuModbusMessage.computeCrc(unitId, body));
    }

    public RtuModbusMessage(ModbusMessage body, short crc) {
        this(System.currentTimeMillis(), body, crc);
    }

    public RtuModbusMessage(long timestamp, ModbusMessage body, short crc) {
        this.timestamp = timestamp;
        this.crc = crc;
        if (body == null) {
            throw new IllegalArgumentException("The body argument must not be null.");
        }
        if (!(body instanceof ModbusPayloadEncoder)) {
            throw new IllegalArgumentException("The body argument must implement ModbusPayloadEncoder.");
        }
        this.body = body;
    }

    @Override
    public RtuModbusMessage validate() throws ModbusValidationException {
        net.solarnetwork.io.modbus.rtu.RtuModbusMessage.super.validate();
        this.body.validate();
        return this;
    }

    public boolean isSameAs(ModbusMessage obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RtuModbusMessage)) {
            return false;
        }
        RtuModbusMessage other = (RtuModbusMessage)obj;
        if (this.crc != other.crc) {
            return false;
        }
        return this.body.isSameAs(other.body);
    }

    public <T extends ModbusMessage> T unwrap(Class<T> msgType) {
        if (msgType.isAssignableFrom(this.body.getClass())) {
            return (T)this.body;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RtuModbusMessage{timestamp=");
        builder.append(this.timestamp);
        builder.append(", crc=");
        builder.append(Short.toUnsignedInt(this.crc));
        builder.append(", body=");
        builder.append(this.body);
        builder.append("}");
        return builder.toString();
    }

    public ModbusMessage getBody() {
        return this.body;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public short getCrc() {
        return this.crc;
    }

    @Override
    public short computeCrc() {
        return RtuModbusMessage.computeCrc(this.getUnitId(), this.body);
    }

    public static short computeCrc(int unitId, ModbusMessage body) {
        if (!(body instanceof ModbusPayloadEncoder)) {
            return 0;
        }
        ModbusPayloadEncoder enc = (ModbusPayloadEncoder)body;
        int len = enc.payloadLength() + 1;
        ByteBuf buf = Unpooled.buffer((int)len);
        buf.writeByte(unitId);
        enc.encodeModbusPayload(buf);
        return ModbusByteUtils.computeCrc((byte[])buf.array(), (int)0, (int)len);
    }

    public int getUnitId() {
        return this.body.getUnitId();
    }

    public ModbusFunction getFunction() {
        return this.body.getFunction();
    }

    public ModbusError getError() {
        return this.body.getError();
    }

    public void encodeModbusPayload(ByteBuf out) {
        int s = out.writerIndex();
        out.writeByte(this.getUnitId());
        ((ModbusPayloadEncoder)this.body).encodeModbusPayload(out);
        int len = out.writerIndex() - s;
        byte[] payload = new byte[len];
        out.slice(s, payload.length).readBytes(payload);
        short crc = ModbusByteUtils.computeCrc((byte[])payload, (int)0, (int)len);
        out.writeShortLE((int)crc);
    }

    public int payloadLength() {
        return 3 + ((ModbusPayloadEncoder)this.body).payloadLength();
    }
}

