/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.rtu;

import net.solarnetwork.io.modbus.ModbusMessage;
import net.solarnetwork.io.modbus.ModbusValidationException;

public interface RtuModbusMessage
extends ModbusMessage {
    public static final String CRC_MISMATCH_VALIDATION_MESSAGE = "CRC mismatch: got 0x%X but computed 0x%X from message data.";

    public long getTimestamp();

    public short getCrc();

    public short computeCrc();

    default public boolean isCrcValid() {
        short computed;
        short provided = this.getCrc();
        return provided == (computed = this.computeCrc());
    }

    default public RtuModbusMessage validate() throws ModbusValidationException {
        short computed;
        short provided = this.getCrc();
        if (provided != (computed = this.computeCrc())) {
            throw new ModbusValidationException(String.format(CRC_MISMATCH_VALIDATION_MESSAGE, provided, computed));
        }
        return this;
    }
}

