/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.rtu.jsc;

import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.solarnetwork.io.modbus.serial.SerialFlowControl;
import net.solarnetwork.io.modbus.serial.SerialParameters;
import net.solarnetwork.io.modbus.serial.SerialParity;
import net.solarnetwork.io.modbus.serial.SerialPort;
import net.solarnetwork.io.modbus.serial.SerialStopBits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JscSerialPort
implements SerialPort {
    private static final Logger log = LoggerFactory.getLogger(JscSerialPort.class);
    private final String name;
    private com.fazecast.jSerialComm.SerialPort serialPort;

    public JscSerialPort(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The serialPort argument must be provided.");
        }
        this.name = name;
    }

    public String getName() {
        return this.serialPort.getSystemPortName();
    }

    public synchronized void open(SerialParameters parameters) throws IOException {
        if (this.serialPort != null) {
            return;
        }
        try {
            this.serialPort = com.fazecast.jSerialComm.SerialPort.getCommPort((String)this.name);
            this.setupSerialPortParameters(this.serialPort, parameters);
            if (!this.serialPort.openPort()) {
                throw new IOException("Serial port [" + this.name + "] failed to open");
            }
        }
        catch (SerialPortInvalidPortException e) {
            try {
                com.fazecast.jSerialComm.SerialPort[] ports = com.fazecast.jSerialComm.SerialPort.getCommPorts();
                if (ports != null) {
                    log.warn("Invalid serial port [{}]; known ports are: [{}]", (Object)this.name, (Object)Arrays.stream(ports).map(p -> p.getSystemPortName()).collect(Collectors.joining(",\n\t", "\n\t", "\n")));
                }
            }
            catch (Exception e2) {
                log.warn("Invalid serial port [{}]; failed to get list of available ports: {}", (Object)this.name, (Object)e2.toString());
            }
            throw new IOException("Invalid serial port [" + this.name + "]");
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("Error opening serial port [" + this.name + "]:" + e.toString(), e);
        }
    }

    private void setupSerialPortParameters(com.fazecast.jSerialComm.SerialPort serialPort, SerialParameters serialParams) {
        int parityCode;
        int stopBitsCode;
        SerialParity parity;
        SerialStopBits stopBits = serialParams.getStopBits() != null ? serialParams.getStopBits() : SerialParameters.DEFAULT_STOP_BITS;
        SerialParity serialParity = parity = serialParams.getParity() != null ? serialParams.getParity() : SerialParameters.DEFAULT_PARITY;
        if (log.isDebugEnabled()) {
            log.debug("Setting serial port [{}] baud = {}, dataBits = {}, stopBits = {}, parity = {}", new Object[]{this.name, serialParams.getBaudRate(), serialParams.getDataBits(), stopBits, parity});
        }
        switch (stopBits) {
            case OnePointFive: {
                stopBitsCode = 2;
                break;
            }
            case Two: {
                stopBitsCode = 3;
                break;
            }
            default: {
                stopBitsCode = 1;
            }
        }
        switch (parity) {
            case Even: {
                parityCode = 2;
                break;
            }
            case Odd: {
                parityCode = 1;
                break;
            }
            case Mark: {
                parityCode = 3;
                break;
            }
            case Space: {
                parityCode = 4;
                break;
            }
            default: {
                parityCode = 0;
            }
        }
        serialPort.setComPortParameters(serialParams.getBaudRate(), serialParams.getDataBits(), stopBitsCode, parityCode);
        serialPort.setFlowControl(this.flowControlMode(serialParams.getFlowControl()));
        if (serialParams.getRs485ModeEnabled() != null) {
            serialPort.setRs485ModeParameters(serialParams.getRs485ModeEnabled().booleanValue(), serialParams.isRs485RtsHighEnabled(), serialParams.isRs485TerminationEnabled(), serialParams.isRs485EchoEnabled(), serialParams.getRs485BeforeSendDelay(), serialParams.getRs485AfterSendDelay());
        }
        serialPort.setComPortTimeouts(1, serialParams.getReadTimeout(), 0);
    }

    private int flowControlMode(Set<SerialFlowControl> flowControl) {
        int result = 0;
        if (flowControl != null) {
            if (flowControl.contains(SerialFlowControl.CTS)) {
                result |= 0x10;
            }
            if (flowControl.contains(SerialFlowControl.RTS)) {
                result |= 1;
            }
            if (flowControl.contains(SerialFlowControl.DSR)) {
                result |= 0x100;
            }
            if (flowControl.contains(SerialFlowControl.DTR)) {
                result |= 0x1000;
            }
            if (flowControl.contains(SerialFlowControl.XonXoffIn)) {
                result |= 0x10000;
            }
            if (flowControl.contains(SerialFlowControl.XonXoffOut)) {
                result |= 0x100000;
            }
        }
        return result;
    }

    public synchronized void close() throws IOException {
        if (this.serialPort == null) {
            return;
        }
        try {
            log.debug("Closing serial port [{}]", (Object)this.name);
            this.serialPort.closePort();
            log.trace("Serial port [{}] closed", (Object)this.name);
        }
        finally {
            this.serialPort = null;
        }
    }

    public synchronized boolean isOpen() {
        return this.serialPort != null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        try {
            if (!this.isOpen()) {
                throw new IOException("Serial port [" + this.name + "] is not open.");
            }
            return this.serialPort.getInputStreamWithSuppressedTimeoutExceptions();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Error opening serial port [" + this.name + "] input stream: " + e, e);
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.isOpen()) {
                throw new IOException("Serial port [" + this.name + "] is not open.");
            }
            return this.serialPort.getOutputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Error opening serial port [" + this.name + "] output stream: " + e, e);
        }
    }
}

