/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.serial;

public enum SerialParity {
    None(0),
    Odd(1),
    Even(2),
    Mark(3),
    Space(4);

    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final String NO_PARITY_ABBREVIATION = "N";
    public static final String ODD_PARITY_ABBREVIATION = "O";
    public static final String EVEN_PARITY_ABBREVIATION = "E";
    public static final String MARK_PARITY_ABBREVIATION = "M";
    public static final String SPACE_PARITY_ABBREVIATION = "S";
    private final int code;

    private SerialParity(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getAbbreviation() {
        switch (this) {
            case Odd: {
                return ODD_PARITY_ABBREVIATION;
            }
            case Even: {
                return EVEN_PARITY_ABBREVIATION;
            }
            case Mark: {
                return MARK_PARITY_ABBREVIATION;
            }
            case Space: {
                return SPACE_PARITY_ABBREVIATION;
            }
        }
        return NO_PARITY_ABBREVIATION;
    }

    public static SerialParity forCode(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return Odd;
            }
            case 2: {
                return Even;
            }
            case 3: {
                return Mark;
            }
            case 4: {
                return Space;
            }
        }
        throw new IllegalArgumentException("Unknown serial parity code [" + code + "]");
    }

    public static SerialParity forAbbreviation(String abbreviation) {
        if (abbreviation == null) {
            return null;
        }
        switch (abbreviation) {
            case "n": 
            case "N": {
                return None;
            }
            case "o": 
            case "O": {
                return Odd;
            }
            case "e": 
            case "E": {
                return Even;
            }
            case "m": 
            case "M": {
                return Mark;
            }
            case "s": 
            case "S": {
                return Space;
            }
        }
        throw new IllegalArgumentException("Unknown serial parity abbreviation [" + abbreviation + "]");
    }
}

