/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.serial;

import java.util.Set;
import net.solarnetwork.io.modbus.serial.SerialFlowControl;
import net.solarnetwork.io.modbus.serial.SerialParity;
import net.solarnetwork.io.modbus.serial.SerialStopBits;

public interface SerialParameters {
    public static final int DEFAULT_BAUD_RATE = 115200;
    public static final SerialStopBits DEFAULT_STOP_BITS = SerialStopBits.One;
    public static final int DEFAULT_DATA_BITS = 8;
    public static final SerialParity DEFAULT_PARITY = SerialParity.None;
    public static final int DEFAULT_READ_TIMEOUT = 1000;
    public static final boolean DEFAULT_RS485_RTS_HIGH_ENABLED = true;
    public static final int DEFAULT_RS485_BEFORE_SEND_DELAY = 5000;
    public static final int DEFAULT_RS485_AFTER_SEND_DELAY = 2000;
    public static final String RS485_RTS_HIGH_FLAG = "RtsHigh";
    public static final String RS485_TERMINATION_FLAG = "Termination";
    public static final String RS485_ECHO_FLAG = "Echo";
    public static final String RS485_BEFORE_SEND_DELAY_FLAG = "BeforeSendDelay";
    public static final String RS485_AFTER_SEND_DELAY_FLAG = "AfterSendDelay";

    default public int getBaudRate() {
        return 115200;
    }

    default public int getDataBits() {
        return 8;
    }

    default public SerialStopBits getStopBits() {
        return DEFAULT_STOP_BITS;
    }

    default public SerialParity getParity() {
        return DEFAULT_PARITY;
    }

    default public Set<SerialFlowControl> getFlowControl() {
        return null;
    }

    default public int getWaitTime() {
        return 0;
    }

    default public int getReadTimeout() {
        return 1000;
    }

    default public String bitsShortcut() {
        SerialParity p = this.getParity();
        SerialStopBits s = this.getStopBits();
        return String.format("%d%s%d", this.getDataBits(), (p != null ? p : DEFAULT_PARITY).getAbbreviation(), (s != null ? s : DEFAULT_STOP_BITS).getCode());
    }

    default public Boolean getRs485ModeEnabled() {
        return null;
    }

    default public boolean isRs485RtsHighEnabled() {
        return true;
    }

    default public boolean isRs485TerminationEnabled() {
        return false;
    }

    default public boolean isRs485EchoEnabled() {
        return false;
    }

    default public int getRs485BeforeSendDelay() {
        return 5000;
    }

    default public int getRs485AfterSendDelay() {
        return 2000;
    }

    default public String rs485Flags() {
        StringBuilder tmp = new StringBuilder();
        if (this.isRs485RtsHighEnabled()) {
            tmp.append(RS485_RTS_HIGH_FLAG);
        }
        if (this.isRs485TerminationEnabled()) {
            if (tmp.length() > 0) {
                tmp.append(",");
            }
            tmp.append(RS485_TERMINATION_FLAG);
        }
        if (this.isRs485EchoEnabled()) {
            if (tmp.length() > 0) {
                tmp.append(",");
            }
            tmp.append(RS485_ECHO_FLAG);
        }
        if (this.getRs485BeforeSendDelay() > 0) {
            if (tmp.length() > 0) {
                tmp.append(",");
            }
            tmp.append(RS485_BEFORE_SEND_DELAY_FLAG).append('=').append(this.getRs485BeforeSendDelay());
        }
        if (this.getRs485AfterSendDelay() > 0) {
            if (tmp.length() > 0) {
                tmp.append(",");
            }
            tmp.append(RS485_AFTER_SEND_DELAY_FLAG).append('=').append(this.getRs485AfterSendDelay());
        }
        return tmp.length() > 0 ? tmp.toString() : null;
    }
}

