/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.serial;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public enum SerialFlowControl {
    None(0),
    RTS(1),
    CTS(2),
    DSR(3),
    DTR(4),
    XonXoffIn(5),
    XonXoffOut(6);

    public static final int NO_FLOW_CONTROL = 0;
    public static final int RTS_FLOW_CONTROL = 1;
    public static final int CTS_FLOW_CONTROL = 2;
    public static final int DSR_FLOW_CONTROL = 3;
    public static final int DTR_FLOW_CONTROL = 4;
    public static final int XONXOFF_IN_FLOW_CONTROL = 5;
    public static final int XONXOFF_OUT_FLOW_CONTROL = 6;
    public static final String NO_FLOW_CONTROL_ABBREVIATION = "no";
    public static final String RTS_FLOW_CONTROL_ABBREVIATION = "RTS";
    public static final String CTS_FLOW_CONTROL_ABBREVIATION = "CTS";
    public static final String DSR_FLOW_CONTROL_ABBREVIATION = "DSR";
    public static final String DTR_FLOW_CONTROL_ABBREVIATION = "DTR";
    public static final String XONXOFF_IN_FLOW_CONTROL_ABBREVIATION = "Xon";
    public static final String XONXOFF_OUT_FLOW_CONTROL_ABBREVIATION = "Xoff";
    private final int code;

    private SerialFlowControl(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SerialFlowControl forCode(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return RTS;
            }
            case 2: {
                return CTS;
            }
            case 3: {
                return DSR;
            }
            case 4: {
                return DTR;
            }
            case 5: {
                return XonXoffIn;
            }
            case 6: {
                return XonXoffOut;
            }
        }
        throw new IllegalArgumentException("Unknown serial flow control code [" + code + "]");
    }

    public static Set<SerialFlowControl> forAbbreviation(String value) {
        String[] components;
        if (value == null || value.isEmpty()) {
            return EnumSet.of(None);
        }
        HashSet<SerialFlowControl> result = new HashSet<SerialFlowControl>(2);
        block0: for (String cmp : components = value.split("\\s*/\\s*")) {
            if (NO_FLOW_CONTROL_ABBREVIATION.equalsIgnoreCase(cmp)) {
                result.add(None);
                continue;
            }
            if (XONXOFF_IN_FLOW_CONTROL_ABBREVIATION.equalsIgnoreCase(cmp)) {
                result.add(XonXoffIn);
                continue;
            }
            if (XONXOFF_OUT_FLOW_CONTROL_ABBREVIATION.equalsIgnoreCase(cmp)) {
                result.add(XonXoffOut);
                continue;
            }
            for (SerialFlowControl e : SerialFlowControl.values()) {
                if (!e.name().equalsIgnoreCase(cmp)) continue;
                result.add(e);
                continue block0;
            }
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Unknown serial flow control abbreviation [" + value + "]");
        }
        EnumSet<SerialFlowControl> enumResult = EnumSet.copyOf(result);
        if (enumResult.size() > 1 && enumResult.contains((Object)None)) {
            enumResult.remove((Object)None);
        }
        return enumResult;
    }
}

