/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus.serial;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.io.modbus.serial.SerialFlowControl;
import net.solarnetwork.io.modbus.serial.SerialParameters;
import net.solarnetwork.io.modbus.serial.SerialParity;
import net.solarnetwork.io.modbus.serial.SerialStopBits;

public class BasicSerialParameters
implements SerialParameters {
    private int baudRate = 115200;
    private int dataBits = 8;
    private SerialStopBits stopBits = DEFAULT_STOP_BITS;
    private SerialParity parity = DEFAULT_PARITY;
    private Set<SerialFlowControl> flowControl;
    private int waitTime;
    private int readTimeout = 1000;
    private Boolean rs485ModeEnabled;
    private boolean rs485RtsHighEnabled = true;
    private boolean rs485TerminationEnabled;
    private boolean rs485EchoEnabled;
    private int rs485BeforeSendDelay = 5000;
    private int rs485AfterSendDelay = 2000;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SerialParameters{");
        builder.append(this.baudRate);
        builder.append(" ");
        builder.append(this.bitsShortcut());
        if (this.flowControl != null && !this.flowControl.isEmpty()) {
            builder.append(", flowControl=");
            builder.append(this.flowControl);
        }
        if (this.waitTime > 0) {
            builder.append(", waitTime=");
            builder.append(this.waitTime);
        }
        if (this.readTimeout > 0) {
            builder.append(", readTimeout=");
            builder.append(this.readTimeout);
        }
        if (this.rs485ModeEnabled != null && this.rs485ModeEnabled.booleanValue()) {
            builder.append(", RS-485");
            String flags = this.rs485Flags();
            if (flags != null) {
                builder.append("=[");
                builder.append(flags);
                builder.append("]");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public void populateRs485Flags(String flags) {
        if (flags == null || flags.isEmpty()) {
            return;
        }
        String[] list = flags.split("\\s*,\\s*");
        Pattern numArgPat = Pattern.compile("(\\w+)=(\\d+)");
        for (String flag : list) {
            boolean enable = true;
            if (flag.startsWith("!")) {
                enable = false;
                flag = flag.substring(1);
            }
            if ("RtsHigh".equalsIgnoreCase(flag)) {
                this.setRs485RtsHighEnabled(enable);
                continue;
            }
            if ("Termination".equalsIgnoreCase(flag)) {
                this.setRs485TerminationEnabled(enable);
                continue;
            }
            if ("Echo".equalsIgnoreCase(flag)) {
                this.setRs485EchoEnabled(enable);
                continue;
            }
            Matcher m = numArgPat.matcher(flag);
            if (!m.matches()) continue;
            flag = m.group(1);
            int num = Integer.parseInt(m.group(2));
            if ("BeforeSendDelay".equalsIgnoreCase(flag)) {
                this.setRs485BeforeSendDelay(num);
                continue;
            }
            if (!"AfterSendDelay".equalsIgnoreCase(flag)) continue;
            this.setRs485AfterSendDelay(num);
        }
    }

    @Override
    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    @Override
    public int getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    @Override
    public SerialStopBits getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(SerialStopBits stopBits) {
        this.stopBits = stopBits;
    }

    @Override
    public SerialParity getParity() {
        return this.parity;
    }

    public void setParity(SerialParity parity) {
        this.parity = parity;
    }

    @Override
    public Set<SerialFlowControl> getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(Set<SerialFlowControl> flowControl) {
        this.flowControl = flowControl;
    }

    @Override
    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Boolean getRs485ModeEnabled() {
        return this.rs485ModeEnabled;
    }

    public void setRs485ModeEnabled(Boolean rs485ModeEnabled) {
        this.rs485ModeEnabled = rs485ModeEnabled;
    }

    @Override
    public boolean isRs485RtsHighEnabled() {
        return this.rs485RtsHighEnabled;
    }

    public void setRs485RtsHighEnabled(boolean rs485RtsHighEnabled) {
        this.rs485RtsHighEnabled = rs485RtsHighEnabled;
    }

    @Override
    public boolean isRs485TerminationEnabled() {
        return this.rs485TerminationEnabled;
    }

    public void setRs485TerminationEnabled(boolean rs485TerminationEnabled) {
        this.rs485TerminationEnabled = rs485TerminationEnabled;
    }

    @Override
    public boolean isRs485EchoEnabled() {
        return this.rs485EchoEnabled;
    }

    public void setRs485EchoEnabled(boolean rs485EchoEnabled) {
        this.rs485EchoEnabled = rs485EchoEnabled;
    }

    @Override
    public int getRs485BeforeSendDelay() {
        return this.rs485BeforeSendDelay;
    }

    public void setRs485BeforeSendDelay(int rs485BeforeSendDelay) {
        this.rs485BeforeSendDelay = rs485BeforeSendDelay;
    }

    @Override
    public int getRs485AfterSendDelay() {
        return this.rs485AfterSendDelay;
    }

    public void setRs485AfterSendDelay(int rs485AfterSendDelay) {
        this.rs485AfterSendDelay = rs485AfterSendDelay;
    }
}

