/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.solarnetwork.io.modbus.ModbusBlockType;
import net.solarnetwork.io.modbus.ModbusFunction;
import net.solarnetwork.io.modbus.UserModbusFunction;

public enum ModbusFunctionCode implements ModbusFunction
{
    ReadCoils(1, ModbusBlockType.Coil, true),
    WriteCoil(5, ModbusBlockType.Coil, false),
    WriteCoils(15, ModbusBlockType.Coil, false),
    ReadDiscreteInputs(2, ModbusBlockType.Discrete, true),
    ReadInputRegisters(4, ModbusBlockType.Input, true),
    ReadHoldingRegisters(3, ModbusBlockType.Holding, true),
    WriteHoldingRegister(6, ModbusBlockType.Holding, false),
    WriteHoldingRegisters(16, ModbusBlockType.Holding, false),
    ReadWriteHoldingRegisters(23, ModbusBlockType.Holding, false),
    MaskWriteHoldingRegister(22, ModbusBlockType.Holding, false),
    ReadFifoQueue(24, ModbusBlockType.Holding, true),
    ReadFileRecord(20, ModbusBlockType.Diagnostic, true),
    WriteFileRecord(21, ModbusBlockType.Diagnostic, false),
    ReadExceptionStatus(7, ModbusBlockType.Diagnostic, true),
    Diagnostics(8, ModbusBlockType.Diagnostic, false),
    GetCommEventCounter(11, ModbusBlockType.Diagnostic, true),
    GetCommEventLog(12, ModbusBlockType.Diagnostic, true),
    ReportServerId(17, ModbusBlockType.Diagnostic, true),
    EncapsulatedInterfaceTransport(43, ModbusBlockType.Diagnostic, true);

    public static final Map<ModbusFunctionCode, ModbusFunctionCode> OPPOSITES;
    private final byte code;
    private final ModbusBlockType blockType;
    private final boolean read;
    private final String displayName;

    private ModbusFunctionCode(byte code, ModbusBlockType blockType, boolean read) {
        this.code = code;
        this.blockType = blockType;
        this.read = read;
        this.displayName = this.name().replaceAll("([a-z])([A-Z])", "$1 $2") + " (" + (code & 0xFF) + ")";
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public ModbusFunctionCode functionCode() {
        return this;
    }

    @Override
    public String toDisplayString() {
        return this.displayName;
    }

    @Override
    public boolean isReadFunction() {
        return this.read;
    }

    @Override
    public ModbusFunctionCode oppositeFunction() {
        return OPPOSITES.get(this);
    }

    @Override
    public ModbusBlockType blockType() {
        return this.blockType;
    }

    public static ModbusFunction valueOf(byte code) {
        if (code < 0) {
            code = (byte)(code & 0x7F);
        }
        switch (code) {
            case 1: {
                return ReadCoils;
            }
            case 2: {
                return ReadDiscreteInputs;
            }
            case 3: {
                return ReadHoldingRegisters;
            }
            case 4: {
                return ReadInputRegisters;
            }
            case 5: {
                return WriteCoil;
            }
            case 6: {
                return WriteHoldingRegister;
            }
            case 7: {
                return ReadExceptionStatus;
            }
            case 8: {
                return Diagnostics;
            }
            case 11: {
                return GetCommEventCounter;
            }
            case 12: {
                return GetCommEventLog;
            }
            case 15: {
                return WriteCoils;
            }
            case 16: {
                return WriteHoldingRegisters;
            }
            case 17: {
                return ReportServerId;
            }
            case 20: {
                return ReadFileRecord;
            }
            case 21: {
                return WriteFileRecord;
            }
            case 22: {
                return MaskWriteHoldingRegister;
            }
            case 23: {
                return ReadWriteHoldingRegisters;
            }
            case 24: {
                return ReadFifoQueue;
            }
            case 43: {
                return EncapsulatedInterfaceTransport;
            }
        }
        return new UserModbusFunction(code);
    }

    public static ModbusFunctionCode forCode(byte code) {
        ModbusFunction fn = ModbusFunctionCode.valueOf(code);
        if (fn instanceof ModbusFunctionCode) {
            return (ModbusFunctionCode)fn;
        }
        throw new IllegalArgumentException("Unknown Modbus function code [" + (code & 0xFF) + "]");
    }

    static {
        HashMap<ModbusFunctionCode, ModbusFunctionCode> m = new HashMap<ModbusFunctionCode, ModbusFunctionCode>(8);
        m.put(ReadCoils, WriteCoils);
        m.put(WriteCoil, ReadCoils);
        m.put(WriteCoils, ReadCoils);
        m.put(ReadHoldingRegisters, WriteHoldingRegisters);
        m.put(WriteHoldingRegister, ReadHoldingRegisters);
        m.put(WriteHoldingRegisters, ReadHoldingRegisters);
        m.put(MaskWriteHoldingRegister, ReadHoldingRegisters);
        m.put(ReadWriteHoldingRegisters, ReadHoldingRegisters);
        m.put(ReadFileRecord, WriteFileRecord);
        m.put(WriteFileRecord, ReadFileRecord);
        OPPOSITES = Collections.unmodifiableMap(m);
    }
}

