/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus;

import net.solarnetwork.io.modbus.ModbusError;
import net.solarnetwork.io.modbus.UserModbusError;

public enum ModbusErrorCode implements ModbusError
{
    IllegalFunction(1),
    IllegalDataAddress(2),
    IllegalDataValue(3),
    ServerDeviceFailure(4),
    Acknowledge(5),
    ServerDeviceBusy(6),
    NegativeAcknowledge(7),
    MemoryParityError(8),
    GatewayPathUnavailable(10),
    GatewayTimeout(11);

    private byte code;

    private ModbusErrorCode(byte code) {
        this.code = code;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public ModbusErrorCode errorCode() {
        return this;
    }

    public static ModbusError valueOf(byte code) {
        switch (code) {
            case 1: {
                return IllegalFunction;
            }
            case 2: {
                return IllegalDataAddress;
            }
            case 3: {
                return IllegalDataValue;
            }
            case 4: {
                return ServerDeviceFailure;
            }
            case 5: {
                return Acknowledge;
            }
            case 6: {
                return ServerDeviceBusy;
            }
            case 7: {
                return NegativeAcknowledge;
            }
            case 8: {
                return MemoryParityError;
            }
            case 10: {
                return GatewayPathUnavailable;
            }
            case 11: {
                return GatewayTimeout;
            }
        }
        return new UserModbusError(code);
    }

    public static ModbusErrorCode forCode(byte code) {
        ModbusError err = ModbusErrorCode.valueOf(code);
        if (err instanceof ModbusErrorCode) {
            return (ModbusErrorCode)err;
        }
        throw new IllegalArgumentException("Unknown Modbus error code [" + (code & 0xFF) + "]");
    }
}

