/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus;

public final class ModbusByteUtils {
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final short[] CRC_HI = new short[]{0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64, 0, 193, 129, 64, 1, 192, 128, 65, 0, 193, 129, 64, 1, 192, 128, 65, 1, 192, 128, 65, 0, 193, 129, 64};
    private static final short[] CRC_LO = new short[]{0, 192, 193, 1, 195, 3, 2, 194, 198, 6, 7, 199, 5, 197, 196, 4, 204, 12, 13, 205, 15, 207, 206, 14, 10, 202, 203, 11, 201, 9, 8, 200, 216, 24, 25, 217, 27, 219, 218, 26, 30, 222, 223, 31, 221, 29, 28, 220, 20, 212, 213, 21, 215, 23, 22, 214, 210, 18, 19, 211, 17, 209, 208, 16, 240, 48, 49, 241, 51, 243, 242, 50, 54, 246, 247, 55, 245, 53, 52, 244, 60, 252, 253, 61, 255, 63, 62, 254, 250, 58, 59, 251, 57, 249, 248, 56, 40, 232, 233, 41, 235, 43, 42, 234, 238, 46, 47, 239, 45, 237, 236, 44, 228, 36, 37, 229, 39, 231, 230, 38, 34, 226, 227, 35, 225, 33, 32, 224, 160, 96, 97, 161, 99, 163, 162, 98, 102, 166, 167, 103, 165, 101, 100, 164, 108, 172, 173, 109, 175, 111, 110, 174, 170, 106, 107, 171, 105, 169, 168, 104, 120, 184, 185, 121, 187, 123, 122, 186, 190, 126, 127, 191, 125, 189, 188, 124, 180, 116, 117, 181, 119, 183, 182, 118, 114, 178, 179, 115, 177, 113, 112, 176, 80, 144, 145, 81, 147, 83, 82, 146, 150, 86, 87, 151, 85, 149, 148, 84, 156, 92, 93, 157, 95, 159, 158, 94, 90, 154, 155, 91, 153, 89, 88, 152, 136, 72, 73, 137, 75, 139, 138, 74, 78, 142, 143, 79, 141, 77, 76, 140, 68, 132, 133, 69, 135, 71, 70, 134, 130, 66, 67, 131, 65, 129, 128, 64};

    private ModbusByteUtils() {
    }

    public static short computeCrc(byte[] data, int start, int end) {
        int hi = 255;
        int lo = 255;
        int next = 0;
        int len = data.length;
        for (int i = start; i < end && i < len; ++i) {
            next = 0xFF & data[i];
            int uIndex = lo ^ next;
            lo = hi ^ CRC_HI[uIndex];
            hi = CRC_LO[uIndex];
        }
        return (short)(hi << 8 | lo);
    }

    public static char[] encodeChar(byte b, char[] toDigits, char[] dest, int destIndex) {
        dest[destIndex] = toDigits[(0xF0 & b) >>> 4];
        dest[destIndex + 1] = toDigits[0xF & b];
        return dest;
    }

    public static byte[] decodeHexString(String s) {
        if (s == null) {
            return new byte[0];
        }
        return ModbusByteUtils.decodeHexPadStart(s.toCharArray());
    }

    public static byte[] decodeHexPadStart(char[] chars) {
        if (chars == null || chars.length < 1) {
            return new byte[0];
        }
        int len = chars.length;
        boolean even = (len & 1) == 0;
        byte[] data = new byte[(even ? len : len + 1) / 2];
        int i = 0;
        int j = 0;
        if (!even) {
            data[i] = (byte)(Character.digit(chars[j], 16) & 0xFF);
            ++i;
            ++j;
        }
        while (j < len) {
            int n = Character.digit(chars[j], 16) << 4;
            n |= Character.digit(chars[++j], 16);
            ++j;
            data[i] = (byte)(n & 0xFF);
            ++i;
        }
        return data;
    }

    public static String encodeHexString(byte[] data, int fromIndex, int toIndex) {
        return ModbusByteUtils.encodeHexString(data, fromIndex, toIndex, false, false);
    }

    public static String encodeHexString(byte[] data, int fromIndex, int toIndex, boolean space) {
        return ModbusByteUtils.encodeHexString(data, fromIndex, toIndex, space, false);
    }

    public static String encodeHexString(byte[] data, int fromIndex, int toIndex, boolean space, boolean lowerCase) {
        if (data == null || data.length < 1 || fromIndex < 0 || fromIndex >= data.length || toIndex < 0 || toIndex <= fromIndex) {
            return "";
        }
        char[] digits = lowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        StringBuilder hexData = new StringBuilder(2 * (toIndex - fromIndex) + (space ? toIndex - fromIndex : 0));
        char[] buffer = new char[2];
        int len = data.length;
        for (int i = fromIndex; i < toIndex && i < len; ++i) {
            if (space && i > fromIndex) {
                hexData.append(' ');
            }
            hexData.append(ModbusByteUtils.encodeChar(data[i], digits, buffer, 0));
        }
        return hexData.toString();
    }

    public static byte[] encode(short[] registers) {
        if (registers == null) {
            return null;
        }
        int len = registers.length;
        byte[] data = new byte[len * 2];
        ModbusByteUtils.encode(registers, data, 0);
        return data;
    }

    public static void encode(short[] registers, byte[] dest, int offset) {
        if (registers == null) {
            return;
        }
        int len = registers.length;
        int i = 0;
        int d = offset;
        while (i < len) {
            dest[d] = (byte)(registers[i] >>> 8 & 0xFF);
            dest[d + 1] = (byte)(registers[i] & 0xFF);
            ++i;
            d += 2;
        }
    }

    public static byte[] encodeUnsigned(int[] registers) {
        if (registers == null) {
            return null;
        }
        int len = registers.length;
        byte[] data = new byte[len * 2];
        int i = 0;
        int d = 0;
        while (i < len) {
            data[d] = (byte)(registers[i] >>> 8 & 0xFF);
            data[d + 1] = (byte)(registers[i] & 0xFF);
            ++i;
            d += 2;
        }
        return data;
    }

    public static short[] decode(byte[] data) {
        if (data == null) {
            return null;
        }
        return ModbusByteUtils.decode(data, 0, data.length);
    }

    public static short[] decode(byte[] data, int start, int end) {
        if (data == null) {
            return null;
        }
        if ((end - start) % 2 != 0) {
            throw new IllegalArgumentException("The byte range has an odd length, but it must be even.");
        }
        short[] r = new short[(end - start) / 2];
        int i = 0;
        int d = start;
        while (i < r.length) {
            r[i] = (short)((data[d] & 0xFF) << 8 | data[d + 1] & 0xFF);
            ++i;
            d += 2;
        }
        return r;
    }

    public static int[] decodeUnsigned(byte[] data) {
        if (data == null) {
            return null;
        }
        return ModbusByteUtils.decodeUnsigned(data, 0, data.length);
    }

    public static int[] decodeUnsigned(byte[] data, int start, int end) {
        if (data == null) {
            return null;
        }
        if ((end - start) % 2 != 0) {
            throw new IllegalArgumentException("The byte data has an odd length, but it must be even.");
        }
        int[] r = new int[(end - start) / 2];
        int i = 0;
        int d = start;
        while (i < r.length) {
            r[i] = (data[d] & 0xFF) << 8 | data[d + 1] & 0xFF;
            ++i;
            d += 2;
        }
        return r;
    }

    public static void reverse(byte[] data) {
        if (data == null) {
            return;
        }
        int max = data.length / 2;
        for (int i = 0; i < max; ++i) {
            byte temp = data[i];
            data[i] = data[data.length - i - 1];
            data[data.length - i - 1] = temp;
        }
    }

    public static void encode16(byte[] data, int offset, int value) {
        data[offset] = (byte)(value >>> 8 & 0xFF);
        data[offset + 1] = (byte)(value & 0xFF);
    }
}

