/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus;

import net.solarnetwork.io.modbus.ModbusBlockType;
import net.solarnetwork.io.modbus.ModbusFunction;

public final class UserModbusFunction
implements ModbusFunction {
    private final String displayName;
    private final byte code;
    private final ModbusBlockType blockType;
    private final boolean readFunction;
    private final ModbusFunction oppositeFunction;

    public UserModbusFunction(byte code) {
        this(null, code, null, false, null);
    }

    public UserModbusFunction(String displayName, byte code) {
        this(displayName, code, null, false, null);
    }

    public UserModbusFunction(String displayName, byte code, ModbusBlockType blockType, boolean readFunction, ModbusFunction oppositeFunction) {
        this.displayName = displayName;
        this.code = code;
        this.blockType = blockType;
        this.readFunction = readFunction;
        this.oppositeFunction = oppositeFunction;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserModbusFunction{");
        builder.append(this.code);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return Byte.hashCode(this.code);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserModbusFunction)) {
            return false;
        }
        UserModbusFunction other = (UserModbusFunction)obj;
        return this.code == other.code;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public ModbusBlockType blockType() {
        return this.blockType;
    }

    @Override
    public boolean isReadFunction() {
        return this.readFunction;
    }

    @Override
    public ModbusFunction oppositeFunction() {
        return this.oppositeFunction;
    }

    @Override
    public String toDisplayString() {
        if (this.displayName == null || this.displayName.isEmpty()) {
            return "UserModbusFunction{" + Byte.toUnsignedInt(this.code) + "}";
        }
        return this.displayName;
    }
}

