/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus;

public enum ModbusBlockType {
    Coil(0, 1, false),
    Discrete(1, 1, true),
    Holding(3, 16, false),
    Input(4, 16, true),
    Diagnostic(-1, 0, true);

    private final int code;
    private final int bitCount;
    private final boolean readOnly;

    private ModbusBlockType(int code, int bitCount, boolean readOnly) {
        this.code = code;
        this.bitCount = bitCount;
        this.readOnly = readOnly;
    }

    public int getCode() {
        return this.code;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isBitType() {
        return this.bitCount == 1;
    }

    public static ModbusBlockType valueOf(int code) {
        switch (code) {
            case 0: {
                return Coil;
            }
            case 1: {
                return Discrete;
            }
            case 3: {
                return Holding;
            }
            case 4: {
                return Input;
            }
            case -1: {
                return Diagnostic;
            }
        }
        return null;
    }

    public static ModbusBlockType forCode(int code) {
        ModbusBlockType b = ModbusBlockType.valueOf(code);
        if (b != null) {
            return b;
        }
        throw new IllegalArgumentException("ModbusBlockType code [" + code + "] not supported.");
    }
}

