/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io.modbus;

import java.math.BigInteger;
import java.util.BitSet;
import net.solarnetwork.io.modbus.AddressedModbusMessage;

public interface BitsModbusMessage
extends AddressedModbusMessage {
    public static BigInteger bitsForBitSet(BitSet set) {
        if (set == null) {
            return BigInteger.ZERO;
        }
        return new BigInteger(set.toByteArray());
    }

    public BigInteger getBits();

    default public boolean isBitEnabled(int idx) {
        if (idx < 0) {
            return false;
        }
        BigInteger bits = this.getBits();
        if (bits == null) {
            return false;
        }
        return bits.testBit(idx);
    }

    default public BitSet toBitSet() {
        BigInteger bits = this.getBits();
        if (bits == null) {
            return null;
        }
        return BitSet.valueOf(bits.toByteArray());
    }
}

